/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.dsl.translator;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.ExprConst;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtAssign;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtIf;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtIncrementalize;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtList;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtPrint;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtRelAssign;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlAssignStatement;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlBooleanVarAssignStatement;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlIfStatement;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlIncrementalizeStatement;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlPrintStatement;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlStatement;
import com.jetbrains.sourceglider.scripts.rml.dsl.lang.UtilsKt;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlBooleanExpressionTranslator;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlParseException;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlRelationExpressionTranslator;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlStatementBlockTranslator;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/sourceglider/scripts/rml/dsl/translator/RmlStatementTranslator;", "", "context", "Lcom/jetbrains/sourceglider/scripts/rml/parser/Context;", "(Lcom/jetbrains/sourceglider/scripts/rml/parser/Context;)V", "boolExprTranslator", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/translator/RmlBooleanExpressionTranslator;", "exprTranslator", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/translator/RmlRelationExpressionTranslator;", "manager", "Lcom/jetbrains/sourceglider/scripts/rml/parser/VariablesManager;", "kotlin.jvm.PlatformType", "stmtBlockTranslator", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/translator/RmlStatementBlockTranslator;", "translate", "Lcom/jetbrains/sourceglider/scripts/rml/ast/Stmt;", "statement", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlStatement;", "intellij.c.dfa"})
public final class RmlStatementTranslator {
    @NotNull
    private final Context context;
    private final VariablesManager manager;
    @NotNull
    private final RmlRelationExpressionTranslator exprTranslator;
    @NotNull
    private final RmlStatementBlockTranslator stmtBlockTranslator;
    @NotNull
    private final RmlBooleanExpressionTranslator boolExprTranslator;

    public RmlStatementTranslator(@NotNull Context context) {
        this.context = context;
        this.manager = this.context.variablesManager;
        this.exprTranslator = new RmlRelationExpressionTranslator(this.context);
        this.stmtBlockTranslator = new RmlStatementBlockTranslator(this.context, this);
        this.boolExprTranslator = new RmlBooleanExpressionTranslator(this.context);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Stmt translate(@NotNull RmlStatement statement) {
        RmlStatement rmlStatement = statement;
        if (rmlStatement instanceof RmlAssignStatement) {
            String relationName = ((RmlAssignStatement)statement).getRelationName();
            Collection $this$toTypedArray$iv = ((RmlAssignStatement)statement).getArgumentVars();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] argumentVars = thisCollection$iv.toArray(new String[0]);
            DomainType[] domainTypeArray = this.manager.getRelation(relationName);
            if (domainTypeArray == null) {
                throw new RmlParseException("Relation " + relationName + " is not registered in input/output/temp block");
            }
            DomainType[] types = domainTypeArray;
            if (this.manager.isInputRelation(relationName)) {
                throw new RmlParseException("Cannot reassign input relation " + relationName);
            }
            Iterable $this$forEachIndexed$iv = ((RmlAssignStatement)statement).getArgumentVars();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void varName;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                if (this.manager.containsDomain((String)varName)) {
                    throw new RmlParseException("In " + relationName + " variable " + (String)varName + " is already defined");
                }
                this.manager.addDomain((String)varName, types[i]);
            }
            RelExpr expr = this.exprTranslator.translate(((RmlAssignStatement)statement).getExpr());
            Iterable $this$forEach$iv = ((RmlAssignStatement)statement).getArgumentVars();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String varName = (String)element$iv;
                boolean bl = false;
                if (!this.manager.wasDomainUsed(varName)) {
                    throw new RmlParseException("Variable " + varName + " of " + relationName + " is not used");
                }
                this.manager.removeDomain(varName);
            }
            return switch (WhenMappings.$EnumSwitchMapping$0[((RmlAssignStatement)statement).getType().ordinal()]) {
                case 1 -> new StmtRelAssign(relationName, argumentVars, expr, this.context, null);
                case 2 -> RmlStatementTranslator.translate$makeAssignmentStmt(relationName, argumentVars, this, expr, 0);
                case 3 -> RmlStatementTranslator.translate$makeAssignmentStmt(relationName, argumentVars, this, expr, 3);
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (rmlStatement instanceof RmlIncrementalizeStatement) {
            StmtList initStmt = this.stmtBlockTranslator.translate(((RmlIncrementalizeStatement)statement).getInitBlock());
            StmtList loopStmt = this.stmtBlockTranslator.translate(((RmlIncrementalizeStatement)statement).getLoopBlock());
            return new StmtIncrementalize(((RmlIncrementalizeStatement)statement).getRelationNames(), initStmt, loopStmt, this.context, null);
        }
        if (rmlStatement instanceof RmlIfStatement) {
            StmtList bodyStmt = this.stmtBlockTranslator.translate(((RmlIfStatement)statement).getBody());
            Expr conditionExpr = this.boolExprTranslator.translate(((RmlIfStatement)statement).getCondition());
            return new StmtIf(conditionExpr, bodyStmt, this.context);
        }
        if (rmlStatement instanceof RmlBooleanVarAssignStatement) {
            int n = UtilsKt.toInt(((RmlBooleanVarAssignStatement)statement).getValue());
            return new StmtAssign(((RmlBooleanVarAssignStatement)statement).getVarName(), new ExprConst(n, this.context), this.context);
        }
        if (rmlStatement instanceof RmlPrintStatement) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = ((RmlPrintStatement)statement).getArgs();
            boolean $i$f$map = false;
            Iterable expr = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                int n;
                void it;
                RmlPrintStatement.PrintArgument varName = (RmlPrintStatement.PrintArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void i = it;
                if (i instanceof RmlPrintStatement.PrintArgument.RelationArgument) {
                    n = 1;
                } else if (i instanceof RmlPrintStatement.PrintArgument.StringArgument) {
                    n = 2;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(n);
            }
            List printTypes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Iterable $this$map$iv2 = ((RmlPrintStatement)statement).getArgs();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                RmlPrintStatement.PrintArgument bl = (RmlPrintStatement.PrintArgument)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                void var14_42 = it;
                if (var14_42 instanceof RmlPrintStatement.PrintArgument.RelationArgument) {
                    string = ((RmlPrintStatement.PrintArgument.RelationArgument)it).getName();
                } else if (var14_42 instanceof RmlPrintStatement.PrintArgument.StringArgument) {
                    string = ((RmlPrintStatement.PrintArgument.StringArgument)it).getValue();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(string);
            }
            List printValues = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
            if (((RmlPrintStatement)statement).getEnd() != null) {
                printTypes.add(2);
                printValues.add(((RmlPrintStatement)statement).getEnd());
            }
            return new StmtPrint(printTypes, printValues, this.context);
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final StmtRelAssign translate$makeAssignmentStmt(String relationName, String[] argumentVars, RmlStatementTranslator this$0, RelExpr expr, int type) {
        RelExprBinary body = new RelExprBinary(type, new RelExprVar(relationName, argumentVars, this$0.context), expr, this$0.context, null);
        return new StmtRelAssign(relationName, argumentVars, body, this$0.context, null);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RmlAssignStatement.OperationType.values().length];
            try {
                nArray[RmlAssignStatement.OperationType.ASSIGN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlAssignStatement.OperationType.UNITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlAssignStatement.OperationType.SUBTRACT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

