/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.dsl.translator;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprComparison;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprConst;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprIf;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprQuantify;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprSingleAttribute;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprUnary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlAtomicConstExpr;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlAtomicExpr;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlBinaryExpr;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlIfExpr;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlQuantifyExpr;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlRelationExpression;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlUnaryExpr;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlVariableComparisonExpr;
import com.jetbrains.sourceglider.scripts.rml.dsl.lang.AttributeVar;
import com.jetbrains.sourceglider.scripts.rml.dsl.lang.ConstValue;
import com.jetbrains.sourceglider.scripts.rml.dsl.lang.RelationArgument;
import com.jetbrains.sourceglider.scripts.rml.dsl.lang.Underscore;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlBooleanExpressionTranslator;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/sourceglider/scripts/rml/dsl/translator/RmlRelationExpressionTranslator;", "", "context", "Lcom/jetbrains/sourceglider/scripts/rml/parser/Context;", "(Lcom/jetbrains/sourceglider/scripts/rml/parser/Context;)V", "boolExprTranslator", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/translator/RmlBooleanExpressionTranslator;", "manager", "Lcom/jetbrains/sourceglider/scripts/rml/parser/VariablesManager;", "translate", "Lcom/jetbrains/sourceglider/scripts/rml/ast/RelExpr;", "expr", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlRelationExpression;", "intellij.c.dfa"})
public final class RmlRelationExpressionTranslator {
    @NotNull
    private final Context context;
    @NotNull
    private final VariablesManager manager;
    @NotNull
    private final RmlBooleanExpressionTranslator boolExprTranslator;

    public RmlRelationExpressionTranslator(@NotNull Context context) {
        this.context = context;
        this.manager = this.context.variablesManager;
        this.boolExprTranslator = new RmlBooleanExpressionTranslator(this.context);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RelExpr translate(@NotNull RmlRelationExpression expr) {
        RmlRelationExpression rmlRelationExpression = expr;
        if (rmlRelationExpression instanceof RmlAtomicExpr) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Object relationDomain;
            String relationName = ((RmlAtomicExpr)expr).getRelationName();
            Object[] objectArray = this.manager.getRelation(relationName);
            if (objectArray == null) {
                throw new RmlParseException("Relation " + relationName + " is not registered in input/output/temp block");
            }
            Object[] domainTypes = objectArray;
            for (Pair pair : CollectionsKt.zip((Iterable)((RmlAtomicExpr)expr).getArguments(), (Object[])domainTypes)) {
                RelationArgument arg = (RelationArgument)pair.component1();
                relationDomain = (DomainType)pair.component2();
                if (!(arg instanceof AttributeVar)) continue;
                String varName = ((AttributeVar)arg).getName();
                this.manager.useDomain(varName);
                DomainType domain = this.manager.getDomain(varName);
                if (domain == null) {
                    this.manager.addDomain(varName, (DomainType)relationDomain);
                    continue;
                }
                if (Intrinsics.areEqual((Object)domain, (Object)relationDomain)) continue;
                throw new RmlParseException("Actual type of " + varName + " is " + domain.getName() + ", but expected " + ((DomainType)relationDomain).getName() + " in " + relationName);
            }
            Iterable $this$map$iv = ((RmlAtomicExpr)expr).getArguments();
            boolean $i$f$map = false;
            relationDomain = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                int n;
                void it;
                RelationArgument relationArgument = (RelationArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void var15_55 = it;
                if (var15_55 instanceof AttributeVar) {
                    n = 0;
                } else if (var15_55 instanceof ConstValue) {
                    n = 1;
                } else if (var15_55 instanceof Underscore) {
                    n = 2;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(n);
            }
            List flags = (List)destination$iv$iv;
            Iterable $this$map$iv2 = ((RmlAtomicExpr)expr).getArguments();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RelationArgument bl = (RelationArgument)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.value());
            }
            List values = (List)destination$iv$iv2;
            Collection $this$toTypedArray$iv = values;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new RelExprVar(relationName, thisCollection$iv.toArray(new String[0]), CollectionsKt.toIntArray((Collection)flags), this.context, null, null);
        }
        if (rmlRelationExpression instanceof RmlAtomicConstExpr) {
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((RmlAtomicConstExpr)expr).getArguments();
            boolean $i$f$map = false;
            Iterable values = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator thisCollection$iv = $this$mapTo$iv$iv.iterator();
            while (thisCollection$iv.hasNext()) {
                void it;
                Object item$iv$iv = thisCollection$iv.next();
                RelationArgument $i$f$mapTo2 = (RelationArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!(it instanceof AttributeVar)) {
                    throw new RmlParseException("Constant relation " + expr + " have to take only variable arguments");
                }
                collection.add(((AttributeVar)it).getName());
            }
            List arguments = (List)destination$iv$iv;
            Iterable $this$forEach$iv = arguments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.manager.useDomain(it);
            }
            Collection $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            return new RelExprConst(((RmlAtomicConstExpr)expr).getType(), thisCollection$iv2.toArray(new String[0]), this.context);
        }
        if (rmlRelationExpression instanceof RmlBinaryExpr) {
            int opCode = switch (WhenMappings.$EnumSwitchMapping$0[((RmlBinaryExpr)expr).getBinOp().ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                case 3 -> 2;
                default -> throw new NoWhenBranchMatchedException();
            };
            RelExpr left = this.translate(((RmlBinaryExpr)expr).getLeftExpr());
            RelExpr right = this.translate(((RmlBinaryExpr)expr).getRightExpr());
            return new RelExprBinary(opCode, left, right, this.context, null);
        }
        if (rmlRelationExpression instanceof RmlQuantifyExpr) {
            for (RmlQuantifyExpr.Quantifier quantifier : ((RmlQuantifyExpr)expr).getQuantifiers()) {
                if (this.manager.containsDomain(quantifier.getName())) {
                    throw new RmlParseException("Redefinition of variable " + quantifier.getName() + " in quantify expression");
                }
                DomainType domainType = this.manager.getDomainType(quantifier.getDomainTypeName());
                this.manager.addDomain(quantifier.getName(), domainType);
            }
            RelExpr body = this.translate(((RmlQuantifyExpr)expr).getExpression());
            int opCode = switch (WhenMappings.$EnumSwitchMapping$1[((RmlQuantifyExpr)expr).getQuantifierType().ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                default -> throw new NoWhenBranchMatchedException();
            };
            for (RmlQuantifyExpr.Quantifier quantifier : CollectionsKt.reversed((Iterable)((RmlQuantifyExpr)expr).getQuantifiers())) {
                if (!this.manager.wasDomainUsed(quantifier.getName())) {
                    throw new RmlParseException("Variable " + quantifier.getName() + " of quantify expression is not used");
                }
                this.manager.removeDomain(quantifier.getName());
                body = new RelExprQuantify(opCode, quantifier.getName(), this.manager.getDomainTypeReference(quantifier.getDomainTypeName()), body, this.context, null);
            }
            return body;
        }
        if (rmlRelationExpression instanceof RmlVariableComparisonExpr) {
            RelationArgument left = ((RmlVariableComparisonExpr)expr).getLeft();
            RelationArgument right = ((RmlVariableComparisonExpr)expr).getRight();
            if (!(left instanceof AttributeVar)) {
                throw new RmlParseException("Left argument of equality comparison is expected to be attribute variable");
            }
            RelExprComparison.BinOp binOp = switch (WhenMappings.$EnumSwitchMapping$2[((RmlVariableComparisonExpr)expr).getEqOp().ordinal()]) {
                case 1 -> RelExprComparison.BinOp.EQ;
                case 2 -> RelExprComparison.BinOp.NEQ;
                case 3 -> RelExprComparison.BinOp.LT;
                case 4 -> RelExprComparison.BinOp.GT;
                case 5 -> RelExprComparison.BinOp.LTEQ;
                case 6 -> RelExprComparison.BinOp.GTEQ;
                default -> throw new NoWhenBranchMatchedException();
            };
            this.manager.useDomain(((AttributeVar)left).getName());
            RelationArgument quantifier = right;
            if (quantifier instanceof AttributeVar) {
                DomainType domainType;
                this.manager.useDomain(((AttributeVar)right).getName());
                if (this.manager.getDomain(((AttributeVar)left).getName()) == null || this.manager.getDomain(((AttributeVar)right).getName()) == null) {
                    throw new RmlParseException("Unknown domain type in equality expression " + expr);
                }
                Object bl = ((RmlVariableComparisonExpr)expr).getRelationalOp();
                AttributeVar attributeVar = bl instanceof AttributeVar ? (AttributeVar)bl : null;
                String opDomName = attributeVar != null ? attributeVar.getName() : null;
                String string = ((AttributeVar)left).getName();
                String string2 = ((AttributeVar)right).getName();
                String string3 = opDomName;
                DomainType domainType2 = this.manager.getDomain(((AttributeVar)left).getName());
                DomainType domainType3 = this.manager.getDomain(((AttributeVar)right).getName());
                String string4 = opDomName;
                if (string4 != null) {
                    void it;
                    bl = string4;
                    DomainType domainType4 = domainType3;
                    DomainType domainType5 = domainType2;
                    String string5 = string3;
                    String string6 = string2;
                    String string7 = string;
                    boolean bl3 = false;
                    DomainType domainType6 = this.manager.getDomain((String)it);
                    string = string7;
                    string2 = string6;
                    string3 = string5;
                    domainType2 = domainType5;
                    domainType3 = domainType4;
                    domainType = domainType6;
                } else {
                    domainType = null;
                }
                Nonterm nonterm = null;
                Context context = this.context;
                RelExprComparison.BinOp binOp2 = binOp;
                DomainType domainType7 = domainType;
                DomainType domainType8 = domainType3;
                DomainType domainType9 = domainType2;
                String string8 = string3;
                String string9 = string2;
                String string10 = string;
                return new RelExprComparison(string10, string9, string8, domainType9, domainType8, domainType7, binOp2, context, nonterm);
            }
            if (quantifier instanceof ConstValue) {
                return new RelExprSingleAttribute(((AttributeVar)left).getName(), this.manager.getDomain(((AttributeVar)left).getName()), ((ConstValue)right).getValue(), binOp, this.context);
            }
            if (quantifier instanceof Underscore) {
                throw new RmlParseException("Usage of any() expression in equality comparison is not allowed");
            }
            throw new NoWhenBranchMatchedException();
        }
        if (rmlRelationExpression instanceof RmlUnaryExpr) {
            RelExpr body = this.translate(((RmlUnaryExpr)expr).getSubexpr());
            if (WhenMappings.$EnumSwitchMapping$3[((RmlUnaryExpr)expr).getUnaryOp().ordinal()] != 1) {
                throw new NoWhenBranchMatchedException();
            }
            return new RelExprUnary(body, 0, this.context, null);
        }
        if (rmlRelationExpression instanceof RmlIfExpr) {
            RelExpr trueBranch = this.translate(((RmlIfExpr)expr).getTrueBranch());
            RelExpr falseBranch = this.translate(((RmlIfExpr)expr).getFalseBranch());
            RmlIfExpr.Condition condition = ((RmlIfExpr)expr).getCondition();
            if (condition instanceof RmlIfExpr.Condition.RelationCondition) {
                RelExpr condition2 = this.translate(((RmlIfExpr.Condition.RelationCondition)((RmlIfExpr)expr).getCondition()).getExpr());
                return new RelExprIf(condition2, trueBranch, falseBranch, this.context);
            }
            if (condition instanceof RmlIfExpr.Condition.BooleanCondition) {
                Expr condition3 = this.boolExprTranslator.translate(((RmlIfExpr.Condition.BooleanCondition)((RmlIfExpr)expr).getCondition()).getExpr());
                return new RelExprIf(condition3, trueBranch, falseBranch, this.context);
            }
            throw new NoWhenBranchMatchedException();
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[RmlBinaryExpr.RelationBinOp.values().length];
            try {
                nArray[RmlBinaryExpr.RelationBinOp.OR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlBinaryExpr.RelationBinOp.AND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlBinaryExpr.RelationBinOp.IMPLICATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RmlQuantifyExpr.QuantifierType.values().length];
            try {
                nArray[RmlQuantifyExpr.QuantifierType.EXIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlQuantifyExpr.QuantifierType.FORALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RmlVariableComparisonExpr.AttributeBinOp.values().length];
            try {
                nArray[RmlVariableComparisonExpr.AttributeBinOp.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlVariableComparisonExpr.AttributeBinOp.NEQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlVariableComparisonExpr.AttributeBinOp.LT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlVariableComparisonExpr.AttributeBinOp.GT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlVariableComparisonExpr.AttributeBinOp.LTEQ.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlVariableComparisonExpr.AttributeBinOp.GTEQ.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[RmlUnaryExpr.RelationUnaryOp.values().length];
            try {
                nArray[RmlUnaryExpr.RelationUnaryOp.NOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

