/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.Arrays;

public class StmtRelAssign
extends Stmt {
    private String relname;
    private String[] domainNames;
    private RelExpr expr;

    public StmtRelAssign(String relname, String[] domainNames, RelExpr expr, Context context, Nonterm nonterm) {
        super(context, nonterm, expr);
        this.relname = relname;
        this.domainNames = domainNames;
        this.expr = expr;
    }

    public String getRelName() {
        return this.relname;
    }

    public String[] getDomainNames() {
        return this.domainNames;
    }

    public RelExpr getExpr() {
        return this.expr;
    }

    @Override
    public void accept(StmtVisitor visitor) {
        if (visitor.visitRelAssignStart(this)) {
            this.expr.accept(visitor);
        }
        visitor.visitRelAssignEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.expr = this.expr.transform(transformer);
        return transformer.transformRelAssign(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result;
        long startMillis = System.currentTimeMillis();
        long startOpCnt = relationsManager.getBDDManager().getOperationsCnt();
        if (threadCallback.checkCancelled()) {
            return;
        }
        Domain[] canonicalDomains = variablesManager.getRelation(this.relname).getDomains();
        Domain[] domains2 = this.pushDomains(variablesManager, domainsPool);
        IRelation oldResult = result = this.expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        result = result.reorderDomains(domains2);
        result = result.fastRename(canonicalDomains, threadCallback);
        oldResult.kill();
        this.popDomains(variablesManager);
        variablesManager.storeRelation(this.relname, result);
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            long opCnt = relationsManager.getBDDManager().getOperationsCnt() - startOpCnt;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes(), opCnt);
        }
    }

    public Domain[] pushDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain[] domains2 = new Domain[this.domainNames.length];
        for (int i = 0; i < this.domainNames.length; ++i) {
            domains2[i] = domainsPool.getDomain(this, this.domainNames[i]);
            variablesManager.storeDomain(this.domainNames[i], domains2[i]);
        }
        return domains2;
    }

    public void popDomains(RuntimeVariablesManager variablesManager) {
        for (int i = 0; i < this.domainNames.length; ++i) {
            variablesManager.removeDomain(this.domainNames[i]);
        }
    }

    @Override
    public String toLongString() {
        return "StmtRelAssign{\n\trelname='" + this.relname + "'\n\tnames=" + Arrays.toString(this.domainNames) + "\n\texpr=" + this.expr.toLongString() + "\n}";
    }
}

