/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprQuantify;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtRelAssign;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StmtIncrementalize
extends Stmt {
    private Stmt header;
    private Stmt loop;
    private String[] relations;

    public StmtIncrementalize(List<String> relsList, Stmt header, Stmt loop, Context context, Nonterm nonterm) {
        super(context, nonterm, header, loop);
        this.header = header;
        this.loop = loop;
        this.relations = ArrayHelper.castStringArray(relsList.toArray());
    }

    public String[] getRelations() {
        return this.relations;
    }

    @Override
    public void accept(StmtVisitor visitor) {
        this.header.accept(visitor);
        if (visitor.visitIncrementalizeStart(this)) {
            this.loop.accept(visitor);
        }
        visitor.visitIncrementalizeEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.header = this.header.transform(transformer);
        this.loop = this.loop.transform(transformer);
        return transformer.transformIncrementalize(this);
    }

    @Override
    public void interpret(final IRelationsManager relationsManager, final RuntimeVariablesManager variablesManager, final ThreadCallback threadCallback, final DomainsPool domainsPool, final UIInstancesProvider uiInstancesProvider, final SymbolTable symbolTable, final ProfileManager profileManager) {
        boolean isEmpty;
        long startMillis = System.currentTimeMillis();
        long startOpCnt = relationsManager.getBDDManager().getOperationsCnt();
        if (threadCallback.checkCancelled()) {
            return;
        }
        IRelation[] results = new IRelation[this.relations.length];
        Domain[][] domains2 = new Domain[this.relations.length][];
        for (int i = 0; i < this.relations.length; ++i) {
            String relation = this.relations[i];
            domains2[i] = variablesManager.getRelation(relation).getDomains();
            results[i] = relationsManager.makeRepositoryRelation(variablesManager.getRelation(relation), relation);
        }
        this.header.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        final Set<String> assignedRelations = this.getAssignedRelations();
        this.loop.accept(new StmtVisitor(){

            @Override
            public boolean visitRelAssignStart(StmtRelAssign stmt) {
                stmt.pushDomains(variablesManager, domainsPool);
                return true;
            }

            @Override
            public void visitRelAssignEnd(StmtRelAssign stmt) {
                stmt.popDomains(variablesManager);
            }

            @Override
            public boolean visitQuantifyStart(RelExprQuantify expr) {
                expr.pushDomain(variablesManager, domainsPool);
                return true;
            }

            @Override
            public void visitQuantifyEnd(RelExprQuantify expr) {
                expr.popDomain(variablesManager);
            }

            @Override
            public void visitVar(RelExprVar expr) {
                if (!assignedRelations.contains(expr.getRelName())) {
                    IRelation result = expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
                    expr.pushPrecomputedResults(result, relationsManager.getBDDManager());
                }
            }
        });
        long bodyDuration = System.currentTimeMillis() - startMillis;
        do {
            IRelation work;
            int i;
            if (threadCallback.checkCancelled()) {
                return;
            }
            for (i = 0; i < this.relations.length; ++i) {
                work = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i]), "0" + this.toString());
                work = work.fastRename(domains2[i], threadCallback);
                IRelation oldResult = results[i];
                results[i] = results[i].unite(work, threadCallback);
                oldResult.kill();
                work.kill();
            }
            this.loop.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
            for (i = 0; i < this.relations.length; ++i) {
                work = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i]), "1" + this.toString());
                work = work.fastRename(domains2[i], threadCallback);
                variablesManager.storeRelation(this.relations[i], work.subtract(results[i], threadCallback));
                work.kill();
            }
            isEmpty = true;
            for (String relation : this.relations) {
                isEmpty &= variablesManager.getRelation(relation).isEmpty();
            }
        } while (!isEmpty);
        for (int i = 0; i < this.relations.length; ++i) {
            variablesManager.storeRelation(this.relations[i], results[i]);
        }
        this.loop.accept(new StmtVisitor(){

            @Override
            public void visitVar(RelExprVar expr) {
                if (!assignedRelations.contains(expr.getRelName())) {
                    expr.popPrecomputedResults(relationsManager.getBDDManager());
                }
            }
        });
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            long opCnt = relationsManager.getBDDManager().getOperationsCnt() - startOpCnt;
            profileManager.addDuration(this, duration, 0L, opCnt);
        }
    }

    @NotNull
    public Set<String> getAssignedRelations() {
        final HashSet<String> assignedRelations = new HashSet<String>();
        this.loop.accept(new StmtVisitor(){

            @Override
            public void visitRelAssignEnd(StmtRelAssign stmt) {
                assignedRelations.add(stmt.getRelName());
            }
        });
        return assignedRelations;
    }

    @Override
    public String toLongString() {
        return "StmtIncrementalize{header=" + this.header.toLongString() + ", loop=" + this.loop.toLongString() + ", relations=" + Arrays.toString(this.relations) + "}";
    }
}

