/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprComparison;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;

public class RelExprSingleAttribute
extends RelExpr {
    private String domain;
    private DomainType domainType;
    private String attribute;
    private RelExprComparison.BinOp binOp;

    public RelExprSingleAttribute(String domainName, DomainType domainType, String attribute, RelExprComparison.BinOp binOp, Context context) {
        super(context, new QueryNode[0]);
        this.domain = domainName;
        this.domainType = domainType;
        this.attribute = attribute;
        this.binOp = binOp;
    }

    public String getDomain() {
        return this.domain;
    }

    public DomainType getDomainType() {
        return this.domainType;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        visitor.visitSingleAttribute(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformSingleAttribute(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return new Domain[]{variablesManager.getDomain(this.domain)};
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        Domain dom = variablesManager.getDomain(this.domain);
        int value = symbolTable.findAttributeInt(dom.getType(), this.attribute);
        IRelation result = relationsManager.makeEmptyRelation(new Domain[]{dom});
        boolean complement = false;
        if (value == -1) {
            uiInstancesProvider.getConsole().println(Messages.getString(RelExprSingleAttribute.class.getName() + "-0") + this.attribute + Messages.getString(RelExprSingleAttribute.class.getName() + "-1"));
        }
        switch (this.binOp) {
            case NEQ: {
                complement = true;
            }
            case EQ: {
                result = relationsManager.makeSingleTuple(dom, value);
                break;
            }
            case GT: {
                complement = true;
            }
            case LTEQ: {
                result = relationsManager.makeLess(dom, value, true, threadCallback);
                break;
            }
            case GTEQ: {
                complement = true;
            }
            case LT: {
                result = relationsManager.makeLess(dom, value, false, threadCallback);
            }
        }
        if (complement) {
            IRelation oldResult = result;
            result = result.complement(threadCallback);
            oldResult.kill();
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprSingleAttribute{domain='" + this.domain + "', attribute='" + this.attribute + "', binOp=" + this.binOp + "}";
    }

    @Override
    public String toShortString() {
        return "(" + this.domain + " " + this.binOp + " " + this.attribute + ")";
    }
}

