/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;

public class RelExprIf
extends RelExpr {
    private RelExpr ifRelExpr;
    private Expr ifExpr;
    private RelExpr thenBranch;
    private RelExpr elseBranch;

    public RelExprIf(RelExpr ifRelExpr, RelExpr thenBranch, RelExpr elseBranch, Context context) {
        super(context, thenBranch, elseBranch);
        this.ifRelExpr = ifRelExpr;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
    }

    public RelExprIf(Expr ifExpr, RelExpr thenBranch, RelExpr elseBranch, Context context) {
        super(context, thenBranch, elseBranch);
        this.ifExpr = ifExpr;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
    }

    public RelExpr getIfRelExpr() {
        return this.ifRelExpr;
    }

    public Expr getIfExpr() {
        return this.ifExpr;
    }

    public RelExpr getThenBranch() {
        return this.thenBranch;
    }

    public RelExpr getElseBranch() {
        return this.elseBranch;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        if (visitor.visitIfStart(this)) {
            if (this.ifRelExpr != null) {
                this.ifRelExpr.accept(visitor);
            }
            this.thenBranch.accept(visitor);
            this.elseBranch.accept(visitor);
        }
        visitor.visitIfEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        if (this.ifRelExpr != null) {
            this.ifRelExpr = this.ifRelExpr.transform(transformer);
        }
        this.thenBranch = this.thenBranch.transform(transformer);
        this.elseBranch = this.elseBranch.transform(transformer);
        return transformer.transformIf(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return this.thenBranch.getDomains(variablesManager, domainsPool);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        if (this.ifExpr != null) {
            int result = this.ifExpr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            if (result != 0) {
                return this.thenBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
            }
            return this.elseBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        }
        IRelation ifResult = this.ifRelExpr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation ifNotResult = ifResult.complement(threadCallback);
        IRelation thenBranchResult = this.thenBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation elseBranchResult = this.elseBranch.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation thenResult = ifResult.unsafeIntersect(thenBranchResult, threadCallback);
        IRelation elseResult = ifNotResult.unsafeIntersect(elseBranchResult, threadCallback);
        IRelation result = thenResult.unsafeUnite(elseResult, threadCallback);
        ifResult.kill();
        ifNotResult.kill();
        thenBranchResult.kill();
        elseBranchResult.kill();
        thenResult.kill();
        elseResult.kill();
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprIf{ifRelExpr=" + (this.ifRelExpr != null ? this.ifRelExpr.toLongString() : "null") + ", ifExpr=" + (this.ifExpr != null ? this.ifExpr.toLongString() : "null") + ", thenBranch=" + this.thenBranch.toLongString() + ", elseBranch=" + this.elseBranch.toLongString() + "}";
    }
}

