/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.Arrays;

public class RelExprConst
extends RelExpr {
    private boolean constant;
    private String[] names;

    public RelExprConst(boolean constant, String[] names, Context context) {
        super(context, new QueryNode[0]);
        this.constant = constant;
        this.names = names;
    }

    public String[] getNames() {
        return this.names;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        visitor.visitConst(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformConst(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain[] domains2 = new Domain[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            domains2[i] = variablesManager.getDomain(this.names[i]);
        }
        return domains2;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        Domain[] domains2 = new Domain[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            domains2[i] = variablesManager.getDomain(this.names[i]);
        }
        return relationsManager.makeEmptyRelation(domains2, this.constant);
    }

    @Override
    public String toLongString() {
        return "RelExprConst{constant=" + this.constant + ", names=" + Arrays.toString(this.names) + "}";
    }

    @Override
    public String toShortString() {
        return Boolean.toString(this.constant);
    }
}

