/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;

public class RelExprBinary
extends RelExpr {
    public static final int UNITE = 0;
    public static final int INTERSECT = 1;
    public static final int IMPLICATE = 2;
    public static final int SUBTRACT = 3;
    private int opCode;
    private RelExpr left;
    private RelExpr right;

    public RelExprBinary(int opCode, RelExpr left, RelExpr right, Context context, Nonterm nonterm) {
        super(context, nonterm, left, right);
        this.opCode = opCode;
        this.left = left;
        this.right = right;
    }

    public RelExpr getLeft() {
        return this.left;
    }

    public RelExpr getRight() {
        return this.right;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        if (visitor.visitBinaryStart(this)) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }
        visitor.visitBinaryEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        this.left = this.left.transform(transformer);
        this.right = this.right.transform(transformer);
        return transformer.transformBinary(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return (Domain[])ArrayHelper.uniteArrays(this.left.getDomains(variablesManager, domainsPool), this.right.getDomains(variablesManager, domainsPool), Domain.class);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result;
        long startMillis = System.currentTimeMillis();
        long startOpCnt = relationsManager.getBDDManager().getOperationsCnt();
        IRelation leftResult = this.right instanceof RelExprVar && variablesManager.getRelation(((RelExprVar)this.right).getRelName()).isEmpty() && this.opCode == 1 ? relationsManager.makeEmptyRelation(this.left.getDomains(variablesManager, domainsPool)) : this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation rightResult = leftResult.isEmpty() && (this.opCode == 1 || this.opCode == 3) ? relationsManager.makeEmptyRelation(this.right.getDomains(variablesManager, domainsPool)) : this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        if (threadCallback.checkCancelled()) {
            return leftResult;
        }
        if (this.opCode == 0) {
            result = leftResult.unsafeUnite(rightResult, threadCallback);
        } else if (this.opCode == 1) {
            result = leftResult.unsafeIntersect(rightResult, threadCallback);
        } else if (this.opCode == 3) {
            IRelation rightResultComplement = rightResult.complement(threadCallback);
            result = leftResult.unsafeIntersect(rightResultComplement, threadCallback);
            rightResultComplement.kill();
        } else if (this.opCode == 2) {
            IRelation leftResultComplement = leftResult.complement(threadCallback);
            result = leftResultComplement.unsafeUnite(rightResult, threadCallback);
            leftResultComplement.kill();
        } else {
            throw new UnsupportedOperationException("Unknown op code " + this.opCode);
        }
        leftResult.kill();
        rightResult.kill();
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            long opCnt = relationsManager.getBDDManager().getOperationsCnt() - startOpCnt;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes(), opCnt);
        }
        return result;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public RelExpr getLeftOperand() {
        return this.left;
    }

    public RelExpr getRightOperand() {
        return this.right;
    }

    @Override
    public int[] getLocation() {
        int[] loc = super.getLocation();
        int[] leftLoc = this.left.getLocation();
        int[] rightLoc = this.right.getLocation();
        if (loc != null && leftLoc != null && rightLoc != null) {
            return new int[]{leftLoc[0], rightLoc[1], loc[2], loc[3]};
        }
        return loc;
    }

    @Override
    public String toLongString() {
        return "RelExprBinary{opCode=" + this.opCode + ", left=" + this.left.toLongString() + ", right=" + this.right.toLongString() + "}";
    }

    @Override
    public String toShortString() {
        String operation = switch (this.opCode) {
            case 0 -> "+";
            case 3 -> "-";
            case 1 -> "*";
            case 2 -> "=>";
            default -> throw new IllegalArgumentException();
        };
        Object leftStr = this.left.toShortString();
        Object rightStr = this.right.toShortString();
        if (this.opCode == 1) {
            if (this.left instanceof RelExprBinary && ((RelExprBinary)this.left).opCode != 1) {
                leftStr = "(" + (String)leftStr + ")";
            }
            if (this.right instanceof RelExprBinary && ((RelExprBinary)this.right).opCode != 1) {
                rightStr = "(" + (String)rightStr + ")";
            }
        }
        return (String)leftStr + " " + operation + " " + (String)rightStr;
    }
}

