/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.intellij.openapi.util.Ref;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.GenericDomainTypeUnifier;
import com.jetbrains.sourceglider.scripts.Script;
import com.jetbrains.sourceglider.scripts.rml.BruteForceDomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RMLParseErrorCallback;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtVisitor;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlProgram;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlParseException;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlProgramTranslator;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.ui.console.Console;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030&2\b\u0010'\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\u0013\u0010)\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010*\u001a\u00020\u0017H\u0016J@\u0010+\u001a\u00020\u001e2\b\u0010,\u001a\u0004\u0018\u00010-2\u0018\u0010.\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\u0006\u0012\u0004\u0018\u00010/\u0018\u00010&2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0012\u00104\u001a\u00020\u001e2\b\u00105\u001a\u0004\u0018\u000106H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/sourceglider/scripts/rml/RMLScriptDSL;", "Lcom/jetbrains/sourceglider/scripts/Script;", "name", "", "program", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlProgram;", "provider", "Lcom/jetbrains/sourceglider/ManagerInstancesProvider;", "(Ljava/lang/String;Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlProgram;Lcom/jetbrains/sourceglider/ManagerInstancesProvider;)V", "relationsManager", "Lcom/jetbrains/sourceglider/relations/IRelationsManager;", "uiInstancesProvider", "Lcom/jetbrains/sourceglider/ui/UIInstancesProvider;", "symbolTable", "Lcom/jetbrains/sourceglider/symtable/SymbolTable;", "(Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlProgram;Ljava/lang/String;Lcom/jetbrains/sourceglider/relations/IRelationsManager;Lcom/jetbrains/sourceglider/ui/UIInstancesProvider;Lcom/jetbrains/sourceglider/symtable/SymbolTable;)V", "domainsPool", "Lcom/jetbrains/sourceglider/scripts/rml/BruteForceDomainsPool;", "manager", "Lcom/jetbrains/sourceglider/scripts/rml/parser/VariablesManager;", "statement", "Lcom/jetbrains/sourceglider/scripts/rml/ast/Stmt;", "compile", "", "rmlCallBack", "Lcom/jetbrains/sourceglider/scripts/rml/RMLParseErrorCallback;", "astNodeCounter", "Lcom/intellij/openapi/util/Ref;", "", "disposeResources", "", "getInputRelations", "", "Lcom/jetbrains/sourceglider/relations/RelationSignature;", "()[Lcom/jetbrains/sourceglider/relations/RelationSignature;", "getMetaInfo", "key", "getMetaInfos", "", "relation", "getName", "getOutputRelations", "hasProgressFeedback", "run", "relationsRepository", "Lcom/jetbrains/sourceglider/repositories/RelationsRepository;", "options", "", "threadCallback", "Lcom/jetbrains/sourceglider/ui/ThreadCallback;", "console", "Lcom/jetbrains/sourceglider/ui/console/Console;", "unifyGenericTypes", "unifier", "Lcom/jetbrains/sourceglider/scripts/GenericDomainTypeUnifier;", "intellij.c.dfa"})
public final class RMLScriptDSL
implements Script {
    @NotNull
    private final RmlProgram program;
    @NotNull
    private final String name;
    @NotNull
    private final IRelationsManager relationsManager;
    @NotNull
    private final UIInstancesProvider uiInstancesProvider;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final VariablesManager manager;
    @Nullable
    private Stmt statement;
    @NotNull
    private final BruteForceDomainsPool domainsPool;

    public RMLScriptDSL(@NotNull RmlProgram program, @NotNull String name, @NotNull IRelationsManager relationsManager, @NotNull UIInstancesProvider uiInstancesProvider, @NotNull SymbolTable symbolTable) {
        this.program = program;
        this.name = name;
        this.relationsManager = relationsManager;
        this.uiInstancesProvider = uiInstancesProvider;
        this.symbolTable = symbolTable;
        this.manager = new VariablesManager(this.symbolTable);
        this.domainsPool = new BruteForceDomainsPool();
    }

    public RMLScriptDSL(@NotNull String name, @NotNull RmlProgram program, @NotNull ManagerInstancesProvider provider) {
        this(program, name, provider.getRelationsManager(), provider.getUIInstancesProvider(), provider.getSymbolTable());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasProgressFeedback() {
        return false;
    }

    @Override
    @NotNull
    public RelationSignature[] getInputRelations() {
        return this.manager.getInputRelations();
    }

    @Override
    @NotNull
    public RelationSignature[] getOutputRelations() {
        return this.manager.getOutputRelations();
    }

    @Override
    @NotNull
    public String getMetaInfo(@Nullable String key) {
        String string = this.manager.getScriptMetaInfo().get(key);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, String> getMetaInfos(@Nullable String relation) {
        return this.manager.getMetaInfo(relation);
    }

    @Override
    public void unifyGenericTypes(@Nullable GenericDomainTypeUnifier unifier) {
        this.manager.unifyGenericTypes(unifier);
    }

    public void run(@Nullable RelationsRepository relationsRepository, @Nullable Map<Object, Object> options, @Nullable ThreadCallback threadCallback, @Nullable Console console) {
        block2: {
            ProfileManager profileManager;
            RuntimeVariablesManager manager2 = new RuntimeVariablesManager(relationsRepository, options, this.manager, this.relationsManager);
            Map<Object, Object> map = options;
            Intrinsics.checkNotNull(map);
            ProfileManager profileManager2 = profileManager = map.containsKey(ProfileManager.class) ? new ProfileManager() : null;
            if (this.statement != null) {
                Stmt stmt = this.statement;
                Intrinsics.checkNotNull((Object)stmt);
                stmt.interpret(this.relationsManager, manager2, threadCallback, this.domainsPool, this.uiInstancesProvider, this.symbolTable, profileManager);
            }
            ThreadCallback threadCallback2 = threadCallback;
            Intrinsics.checkNotNull((Object)threadCallback2);
            if (!threadCallback2.checkCancelled()) {
                manager2.storeOutputRelations(options, threadCallback);
            }
            ProfileManager profileManager3 = profileManager;
            if (profileManager3 == null) break block2;
            profileManager3.dump(console, this.statement, null, options, this.name, manager2);
        }
    }

    public final boolean compile(@NotNull RMLParseErrorCallback rmlCallBack, @NotNull Ref<Integer> astNodeCounter) {
        RmlProgramTranslator translator = new RmlProgramTranslator(this.manager, this.symbolTable, astNodeCounter, false, 8, null);
        try {
            this.statement = translator.translate(this.program);
        }
        catch (RmlParseException e) {
            rmlCallBack.error(e.getMessage() + " in script \"" + this.name + "\"");
            return false;
        }
        Stmt stmt = this.statement;
        Intrinsics.checkNotNull((Object)stmt);
        this.domainsPool.arrangeDomains(stmt, this.manager);
        this.manager.removeUnusedRelations();
        return true;
    }

    @Override
    public void disposeResources() {
        block0: {
            Stmt stmt = this.statement;
            if (stmt == null) break block0;
            stmt.accept(new StmtVisitor(){

                public void visitVar(@NotNull RelExprVar expr) {
                    expr.disposeResources();
                }
            });
        }
    }
}

