/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.sourceglider.scripts.rml.PrettyPrintable;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtRelAssign;
import com.jetbrains.sourceglider.ui.console.Console;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ProfileManager {
    private Map<QueryNode, ProfileData> map = new HashMap<QueryNode, ProfileData>();
    public static String JSON_FILE = "JSON_FILE";

    public void addDuration(QueryNode node, long duration, long bddSize, long bddOpCnt) {
        ProfileData profileData = this.map.get(node);
        if (profileData == null) {
            profileData = new ProfileData();
            this.map.put(node, profileData);
        }
        profileData.totalDuration += duration;
        profileData.totalBddSize += bddSize;
        profileData.totalBddOpCnt += bddOpCnt;
        ++profileData.totalCount;
    }

    public void dump(Console console, QueryNode node, String query, Map<Object, Object> options, String scriptName, RuntimeVariablesManager manager2) {
        String jsonFile = (String)options.get(JSON_FILE);
        if (jsonFile != null) {
            jsonFile = jsonFile.replace(".json", "-" + scriptName + ".json");
            JSONObject object = this.dumpJson(node, query);
            JSONArray relations = new JSONArray();
            object.put((Object)"relations", (Object)relations);
            for (String relation : manager2.getAvailableRelations().stream().sorted().toList()) {
                JSONObject relInfo = new JSONObject();
                relInfo.put((Object)"name", (Object)relation);
                relInfo.put((Object)"tuplesCnt", (Object)manager2.getRelation(relation).getAllTuples().length);
                relations.add((Object)relInfo);
            }
            try {
                FileUtil.writeToFile((File)new File(jsonFile), (String)object.toJSONString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList<QueryNode> nodes = new ArrayList<QueryNode>(this.map.keySet());
        nodes.sort((o1, o2) -> {
            long diff2 = this.map.get((Object)o1).totalDuration - this.map.get((Object)o2).totalDuration;
            return diff2 < 0L ? 1 : (diff2 > 0L ? -1 : 0);
        });
        console.println("Operations profile:");
        for (QueryNode n : nodes) {
            int newline;
            ProfileData profileData = this.map.get(n);
            int[] location = n.getLocation();
            Object astString = null;
            if (query != null && (newline = ((String)(astString = query.substring(location[0], location[1]))).indexOf("\n")) != -1) {
                astString = ((String)astString).substring(0, newline - 1) + "...";
            }
            console.println("time: " + (double)profileData.totalDuration / 1000.0 + ", BDD nodes: " + profileData.totalBddSize + ", invocations: " + profileData.totalCount + (String)(location != null ? ", loc: " + location[2] + ":" + location[3] + "\t" + (String)astString : ""));
        }
    }

    public JSONObject dumpJson(QueryNode node, String query) {
        ProfileData profileData = this.map.get(node);
        int[] location = node.getLocation();
        JSONObject object = new JSONObject();
        object.put((Object)"node", (Object)node.getClass().getSimpleName());
        object.put((Object)"id", (Object)node.getAstNodeId());
        if (location != null) {
            String astString = query.substring(location[0], location[1]);
            object.put((Object)"location", (Object)(location[2] + ":" + location[3]));
            if (node instanceof RelExpr || node instanceof StmtRelAssign) {
                object.put((Object)"code", (Object)astString);
            }
        }
        if (node instanceof PrettyPrintable) {
            String text = ((PrettyPrintable)((Object)node)).toShortString();
            object.put((Object)"text", text.length() > 100 ? text.substring(0, 100) + "..." : text);
        }
        if (profileData != null) {
            object.put((Object)"time", (Object)((double)profileData.totalDuration / 1000.0));
            object.put((Object)"BDD operations count", (Object)profileData.totalBddOpCnt);
            object.put((Object)"BDD nodes", (Object)profileData.totalBddSize);
            object.put((Object)"invocations", (Object)profileData.totalCount);
            if (!profileData.domainInfo.isEmpty()) {
                JSONObject domains2 = new JSONObject();
                domains2.put((Object)"first", (Object)profileData.domainInfo.first);
                domains2.put((Object)"middle", (Object)profileData.domainInfo.mid);
                domains2.put((Object)"last", (Object)profileData.domainInfo.last);
                object.put((Object)"domains", (Object)domains2);
            }
        }
        JSONArray children = new JSONArray();
        children.addAll((Collection)ContainerUtil.map((Object[])node.getChildren(), n -> this.dumpJson((QueryNode)n, query)));
        object.put((Object)"children", (Object)children);
        return object;
    }

    private static class ProfileData {
        private long totalDuration;
        private long totalBddSize;
        private long totalBddOpCnt;
        private long totalCount;
        private DomainProfileInfo domainInfo = new DomainProfileInfo();

        private ProfileData() {
        }
    }

    public static class DomainProfileInfo {
        public int first;
        public int mid;
        public int last;

        public void add(DomainProfileInfo info) {
            this.first += info.first;
            this.mid += info.mid;
            this.last += info.last;
        }

        public boolean isEmpty() {
            return this.first + this.mid + this.last == 0;
        }
    }
}

