/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprQuantify;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtPrint;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtRelAssign;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtVisitor;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainConstraintCollector
extends StmtVisitor {
    private Map<String, List<DomainConstraint>> constraintsMap;
    private Map<StmtRelAssign, DomainConstraint[][]> assignConstraints = new HashMap<StmtRelAssign, DomainConstraint[][]>();
    private Map<RelExprQuantify, List<DomainConstraint>> quantifyConstraints = new HashMap<RelExprQuantify, List<DomainConstraint>>();
    private Map<StmtPrint.RelationPrintBundle, DomainConstraint[][]> printConstraints = new HashMap<StmtPrint.RelationPrintBundle, DomainConstraint[][]>();
    private final RuntimeVariablesManager variablesManager;

    public DomainConstraintCollector(RuntimeVariablesManager variablesManager) {
        this.variablesManager = variablesManager;
    }

    public DomainConstraint[][] getAssignConstraints(StmtRelAssign stmt) {
        return this.assignConstraints.get(stmt);
    }

    public List<DomainConstraint> getQuantifyConstraints(RelExprQuantify expr) {
        return this.quantifyConstraints.get(expr);
    }

    public DomainConstraint[][] getPrintConstraints(StmtPrint.RelationPrintBundle bundle) {
        return this.printConstraints.get(bundle);
    }

    @Override
    public boolean visitRelAssignStart(StmtRelAssign stmt) {
        String[] domainNames = stmt.getDomainNames();
        this.constraintsMap = new HashMap<String, List<DomainConstraint>>();
        ArrayList[] vectors = new ArrayList[domainNames.length];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = new ArrayList();
            this.constraintsMap.put(domainNames[i], vectors[i]);
        }
        return true;
    }

    @Override
    public void visitRelAssignEnd(StmtRelAssign stmt) {
        String[] domainNames = stmt.getDomainNames();
        DomainConstraint[][] constraints = new DomainConstraint[domainNames.length][];
        for (int i = 0; i < constraints.length; ++i) {
            constraints[i] = ArrayHelper.castArray(this.constraintsMap.get(domainNames[i]).toArray(), DomainConstraint.class);
        }
        this.assignConstraints.put(stmt, constraints);
    }

    @Override
    public boolean visitPrintStart(StmtPrint stmt) {
        this.constraintsMap = new HashMap<String, List<DomainConstraint>>();
        for (Object printValue : stmt.getPrintValues()) {
            if (!(printValue instanceof StmtPrint.RelationPrintBundle)) continue;
            StmtPrint.RelationPrintBundle bundle = (StmtPrint.RelationPrintBundle)printValue;
            this.printConstraints.put(bundle, new DomainConstraint[bundle.domainNames.size()][]);
            ArrayList[] vectors = new ArrayList[bundle.domainNames.size()];
            for (int j = 0; j < vectors.length; ++j) {
                vectors[j] = new ArrayList();
                this.constraintsMap.put(bundle.domainNames.get(j), vectors[j]);
            }
        }
        return true;
    }

    @Override
    public void visitPrintEnd(StmtPrint stmt) {
        for (Object printValue : stmt.getPrintValues()) {
            if (!(printValue instanceof StmtPrint.RelationPrintBundle)) continue;
            StmtPrint.RelationPrintBundle bundle = (StmtPrint.RelationPrintBundle)printValue;
            for (int j = 0; j < bundle.domainNames.size(); ++j) {
                this.printConstraints.get((Object)bundle)[j] = ArrayHelper.castArray(this.constraintsMap.get(bundle.domainNames.get(j)).toArray(), DomainConstraint.class);
            }
        }
    }

    @Override
    public boolean visitQuantifyStart(RelExprQuantify expr) {
        ArrayList myConstraints = new ArrayList();
        this.constraintsMap.put(expr.getQuantifier(), myConstraints);
        this.quantifyConstraints.put(expr, myConstraints);
        return true;
    }

    @Override
    public void visitVar(RelExprVar expr) {
        for (int i = 0; i < expr.getValuesCnt(); ++i) {
            if (expr.getFlag(i) != 0) continue;
            DomainType type = this.variablesManager.getRelation(expr.getRelName()).getDomainType(i);
            List<DomainConstraint> vector = this.constraintsMap.get(expr.getValue(i));
            for (int j = 0; j < expr.getValuesCnt(); ++j) {
                if (expr.getFlag(j) != 0 && expr.getFlag(j) != 2 || this.variablesManager.getRelation(expr.getRelName()).getDomainType(j) != type) continue;
                vector.add(new DomainConstraint(expr, j));
            }
        }
    }
}

