/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.repositories;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.HashMap;

public class MemoryRelationsRepository
extends RelationsRepository {
    private final UICallback uiCallback;
    private HashMap<String, IRelation> nameToRelationMap = new HashMap();
    protected IRelationsManager relationsManager;

    public MemoryRelationsRepository(IRelationsManager relationsManager, UICallback callback) {
        this.relationsManager = relationsManager;
        this.uiCallback = callback;
    }

    @Override
    public void clear() {
        this.nameToRelationMap = new HashMap();
    }

    @Override
    public String[] getAvailableRelations() {
        return ArrayHelper.castStringArray(this.nameToRelationMap.keySet().toArray());
    }

    @Override
    public boolean containsRelation(String name) {
        return this.nameToRelationMap.containsKey(name);
    }

    @Override
    public IRelation getRelation(String name) {
        return this.relationsManager.makeRepositoryRelation(this.nameToRelationMap.get(name), name);
    }

    @Override
    public DomainType[] getDomainTypes(String name) {
        return this.nameToRelationMap.get(name).getDomainTypes();
    }

    @Override
    public void addRelation(String name, IRelation relation) {
        this.nameToRelationMap.put(name, relation);
        super.addRelation(name, relation);
    }

    @Override
    public void deleteRelation(String name) {
        if (!this.nameToRelationMap.containsKey(name)) {
            this.uiCallback.showError(Messages.getString(MemoryRelationsRepository.class.getName() + "-0") + name, false);
        }
        this.nameToRelationMap.remove(name);
        super.deleteRelation(name);
    }
}

