/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.incremental;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationsCache {
    static final int NO_KEY = -1;
    private static final int CACHE_SIZE_MASK = 65535;
    private final KeyEntry[] keysCache = new KeyEntry[65536];
    private int firstFreeKey;
    private final List<ResultsCache> resultsCaches = new ArrayList<ResultsCache>();
    private final Map<String, Integer> repositoryRelationsKeys = new HashMap<String, Integer>();
    private final IBDDManager bddManager;

    public RelationsCache(IBDDManager bddManager) {
        this.bddManager = bddManager;
    }

    public void rewindCaches() {
        for (ResultsCache resultsCache : this.resultsCaches) {
            resultsCache.rewind();
        }
    }

    public int getRepositoryRelationKey(String relation) {
        if (!this.repositoryRelationsKeys.containsKey(relation)) {
            this.repositoryRelationsKeys.put(relation, this.firstFreeKey++);
            this.resultsCaches.add(new ResultsCache());
        }
        return this.repositoryRelationsKeys.get(relation);
    }

    public int getKey(int leftKey, int rightKey, int opCode) {
        if (leftKey == -1 || rightKey == -1) {
            return -1;
        }
        int hashCode = (leftKey * 31 + rightKey) * 31 + opCode;
        KeyEntry entry = this.keysCache[hashCode & 0xFFFF];
        while (entry != null) {
            if (entry.leftKey == leftKey && entry.rightKey == rightKey && entry.opCode == opCode) {
                return entry.key;
            }
            entry = entry.next;
        }
        entry = new KeyEntry(leftKey, rightKey, opCode, this.firstFreeKey++);
        entry.next = this.keysCache[hashCode & 0xFFFF];
        this.keysCache[hashCode & 0xFFFF] = entry;
        this.resultsCaches.add(new ResultsCache());
        return this.firstFreeKey - 1;
    }

    public int getKey(int operandKey, int opCode) {
        if (operandKey == -1) {
            return -1;
        }
        return this.getKey(operandKey, 0, opCode);
    }

    public int getKey(int value) {
        return this.getKey(0, 0, value);
    }

    public IBDD getLastCached(int key, boolean full) {
        if (key == -1) {
            return full ? this.bddManager.getOne() : this.bddManager.getZero();
        }
        return this.resultsCaches.get(key).getLast(full);
    }

    public IBDD getLastCached(int key) {
        return this.getLastCached(key, false);
    }

    public void save(int key, IBDD result) {
        if (key != -1) {
            this.resultsCaches.get(key).save(result);
        }
    }

    private static class KeyEntry {
        int leftKey;
        int rightKey;
        Object operand;
        int opCode;
        KeyEntry next;
        int key;

        KeyEntry(int leftKey, int rightKey, int opCode, int key) {
            this.leftKey = leftKey;
            this.rightKey = rightKey;
            this.opCode = opCode;
            this.key = key;
        }
    }

    private class ResultsCache {
        private int curIteration;
        private final List<IBDD> results = new ArrayList<IBDD>();

        private ResultsCache() {
        }

        public void rewind() {
            this.curIteration = 0;
        }

        IBDD getLast(boolean full) {
            if (this.curIteration < this.results.size()) {
                IBDD result = this.results.get(this.curIteration);
                result.incRefCount();
                return result;
            }
            return full ? RelationsCache.this.bddManager.getOne() : RelationsCache.this.bddManager.getZero();
        }

        void save(IBDD result) {
            result.incRefCount();
            if (this.curIteration < this.results.size()) {
                this.results.get(this.curIteration).decRefCount();
                this.results.set(this.curIteration, result);
            } else {
                this.results.add(result);
            }
            ++this.curIteration;
        }
    }
}

