/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa;

import com.jetbrains.gsa.data.List;
import com.jetbrains.gsa.data.ListItr;
import com.jetbrains.gsa.files.EchoFile;
import com.jetbrains.gsa.files.ErrorsFile;
import com.jetbrains.gsa.files.File;
import com.jetbrains.gsa.files.LexAnFile;
import com.jetbrains.gsa.files.NontermFile;
import com.jetbrains.gsa.files.ParserFile;
import com.jetbrains.gsa.others.GSAException;
import java.util.Arrays;

public class GSAMain {
    public static int classes = 0;
    private static String curDir;
    private static String parserDir;
    private static String importDir;
    private static String genFilesDir;
    private static String echoFileName;
    private static boolean generateLexAn;

    public static void main(String[] args2) {
        GSAMain.processParams(args2);
        List files = null;
        try {
            files = File.packageName == null ? GSAMain.searchClasses(curDir, "") : GSAMain.searchClasses(curDir, File.packageName + ".");
        }
        catch (GSAException e) {
            e.printStackTrace();
            System.exit(1);
        }
        int errors = 0;
        if (!files.isEmpty()) {
            files.add(new ParserFile(genFilesDir + "Parser.java"));
            files.add(new LexAnFile(genFilesDir + "LexerConsts.java"));
            if (!echoFileName.isEmpty()) {
                files.add(new EchoFile(curDir + echoFileName));
            }
            ListItr itr = new ListItr(files);
            while (!itr.isDone()) {
                File file = (File)itr.get();
                try {
                    file.collect();
                    if (file instanceof NontermFile) {
                        if (((NontermFile)file).isNonterm) {
                            file.writeToDisk(true);
                            ++classes;
                        }
                    } else {
                        file.writeToDisk(!(file instanceof ErrorsFile));
                    }
                }
                catch (GSAException e) {
                    e.printStackTrace();
                    ++errors;
                }
                itr.next();
            }
        }
        System.out.println("GSA: " + classes + " class(es) processed; " + errors + " errors found");
    }

    static List searchClasses(String curDir, String packageDir) throws GSAException {
        java.io.File dir = new java.io.File(curDir);
        String[] arr = dir.list();
        List ans = new List();
        if (arr == null) {
            throw new GSAException("Working directory is incorrect");
        }
        for (String anArr : arr) {
            if (new java.io.File(curDir + anArr).isDirectory()) {
                ans.cat(GSAMain.searchClasses(curDir + anArr + java.io.File.separator, packageDir + anArr + "."));
                continue;
            }
            if (!anArr.endsWith(".java")) continue;
            ans.add(new NontermFile(curDir + anArr, importDir));
        }
        return ans;
    }

    static void processParams(String[] args2) {
        if (args2.length == 0 || args2[0].equals("?") || args2[0].equals("-?")) {
            GSAMain.help();
            System.exit(0);
        }
        int curArg = 0;
        boolean wasOption = true;
        while (wasOption) {
            wasOption = false;
            if (curArg < args2.length && args2[curArg].equals("-echo")) {
                echoFileName = args2[curArg + 1];
                curArg += 2;
                wasOption = true;
            }
            if (curArg < args2.length && args2[curArg].equals("-package")) {
                File.packageName = args2[curArg + 1];
                curArg += 2;
                wasOption = true;
            }
            if (curArg < args2.length && args2[curArg].equals("-parserDir")) {
                parserDir = args2[curArg + 1];
                curArg += 2;
                wasOption = true;
            }
            if (curArg < args2.length && args2[curArg].equals("-genDir")) {
                genFilesDir = args2[curArg + 1] + java.io.File.separator;
                curArg += 2;
                wasOption = true;
            }
            if (curArg >= args2.length || !args2[curArg].equals("-import")) continue;
            importDir = args2[curArg + 1];
            curArg += 2;
            wasOption = true;
        }
        curDir = String.join((CharSequence)" ", Arrays.asList(args2).subList(curArg, args2.length));
        curDir = curDir + java.io.File.separator;
        if (genFilesDir == null) {
            genFilesDir = curDir;
        }
    }

    static void help() {
        System.out.println("Usage: java -jar GSA.jar [ -package <Package Name> ] [ -echo <Filename> ] [ -import <package> ] [ -parserDir <name of subdirectory> ] [ -genDir <path to directory> ] <Directory Path>\nFor more help see tutoral.htm\n");
    }

    static {
        parserDir = "parser";
        importDir = "";
        echoFileName = "";
        generateLexAn = true;
    }
}

