/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.settings;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cmake.colors.CMakeColor;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.settings.CMakeSignaturesProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cmake/settings/CMakeKeywordArgumentAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isKeyword", "", "commandName", "", "Lcom/jetbrains/cmake/psi/CMakeLiteral;", "intellij.cmake.psi"})
public final class CMakeKeywordArgumentAnnotator
implements Annotator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKeyword(String commandName, CMakeLiteral element) {
        String normalizedCommandName = StringUtil.toLowerCase((String)commandName);
        CMakeSignaturesProvider signProvider = CMakeSignaturesProvider.Companion.getInstance();
        if (!signProvider.getKeywordsForBuiltInCommands().containsKey(normalizedCommandName)) return false;
        List<String> list = signProvider.getKeywordsForBuiltInCommands().get(normalizedCommandName);
        Intrinsics.checkNotNull(list);
        if (!list.contains(element.getText())) return false;
        return true;
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement command;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof CMakeArgument) || ((CMakeArgument)element).getCMakeLiteral() == null) {
            return;
        }
        PsiElement psiElement = ((CMakeArgument)element).getParent();
        Object object = command = psiElement != null ? psiElement.getParent() : null;
        if (!(command instanceof CMakeCommand)) {
            return;
        }
        String commandName = CMakePsiUtils.findCommandName((CMakeCommand)command);
        if (commandName == null) {
            return;
        }
        CMakeLiteral cMakeLiteral = ((CMakeArgument)element).getCMakeLiteral();
        Intrinsics.checkNotNull((Object)cMakeLiteral);
        if (this.isKeyword(commandName, cMakeLiteral)) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(CMakeColor.KEYWORD.getTextAttributesKey()).create();
        }
    }
}

