/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.TreeItem;
import com.jetbrains.cmake.CMakeBundle;
import com.jetbrains.cmake.psi.CMakeElementType;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.CMakeVarReferenceLexer;
import com.jetbrains.cmake.psi.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\u00042\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0015\u001a\u00020\u00042\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cmake/psi/CMakeVarReferenceAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "buildTree", "Lcom/intellij/util/TreeItem;", "Lcom/jetbrains/cmake/psi/Token;", "Lcom/jetbrains/cmake/psi/TreeNode;", "tokens", "", "text", "", "doAnnotate", "tree", "Lcom/jetbrains/cmake/psi/CMakeLiteral;", "lex", "visit", "node", "Companion", "intellij.cmake.psi"})
public final class CMakeVarReferenceAnnotator
implements Annotator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final CMakeElementType VAR_REFERENCE = new CMakeElementType("variable reference");
    @JvmField
    @NotNull
    public static final CMakeElementType COMPLEX_LITERAL = new CMakeElementType("complex literal");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        List<Token> tokens;
        String literalText;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    if (!(element instanceof CMakeLiteral)) {
                        return;
                    }
                    if (((CMakeLiteral)element).getArgument().isBracketArgument()) {
                        return;
                    }
                    literalText = ((CMakeLiteral)element).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)literalText, (String)"literalText");
                    tokens = this.lex(literalText);
                    if (tokens.isEmpty()) break block10;
                    Iterable $this$none$iv = tokens;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            Token it = (Token)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_START))) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block11;
            }
            return;
        }
        TreeItem<Token> tree = this.buildTree(tokens, literalText);
        this.doAnnotate(tree, (CMakeLiteral)element, holder);
    }

    private final List<Token> lex(String text) {
        CMakeVarReferenceLexer lexer = new CMakeVarReferenceLexer();
        lexer.start(text);
        List tokens = new ArrayList();
        while (lexer.getTokenType() != null) {
            IElementType iElementType = lexer.getTokenType();
            Intrinsics.checkNotNull((Object)iElementType);
            int n = lexer.getTokenStart();
            int n2 = lexer.getTokenEnd();
            String string = lexer.getTokenText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lexer.tokenText");
            tokens.add(new Token(iElementType, n, n2, string));
            lexer.advance();
        }
        return tokens;
    }

    private final TreeItem<Token> buildTree(List<Token> tokens, String text) {
        TreeItem base;
        if (tokens.size() == 1) {
            return new TreeItem((Object)tokens.get(0));
        }
        TreeItem currentNode = base = new TreeItem((Object)new Token(COMPLEX_LITERAL, 0, text.length(), text));
        for (Token token : tokens) {
            IElementType iElementType = token.getType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_START))) {
                TreeItem varReference = new TreeItem((Object)new Token(VAR_REFERENCE, token.getStart(), token.getStart() + 1, " "));
                currentNode.addChild(varReference);
                currentNode = varReference;
                currentNode.addChild(new TreeItem((Object)token));
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_END))) {
                currentNode.addChild(new TreeItem((Object)token));
                TreeItem parent = currentNode.getParent();
                if (parent == null) {
                    IElementType iElementType2 = TokenType.ERROR_ELEMENT;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"ERROR_ELEMENT");
                    currentNode.addChild(new TreeItem((Object)new Token(iElementType2, token.getEnd(), token.getEnd() + 1, " ")));
                    break;
                }
                currentNode = parent;
                continue;
            }
            if ((Intrinsics.areEqual((Object)iElementType, (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_NAME)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)CMakeTokenTypes.LITERAL)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)TokenType.BAD_CHARACTER)) {
                currentNode.addChild(new TreeItem((Object)token));
                continue;
            }
            currentNode.addChild(new TreeItem((Object)token.errorToken()));
        }
        return base;
    }

    private final void doAnnotate(TreeItem<Token> tree, CMakeLiteral element, AnnotationHolder holder) {
        if (!Intrinsics.areEqual((Object)((Token)tree.getData()).getType(), (Object)((Object)COMPLEX_LITERAL))) {
            return;
        }
        this.visit(tree, element, holder);
    }

    private final void visit(TreeItem<Token> node, CMakeLiteral element, AnnotationHolder holder) {
        IElementType iElementType = ((Token)node.getData()).getType();
        if (!((((Intrinsics.areEqual((Object)iElementType, (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_START)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_END))) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_NAME))) ? true : Intrinsics.areEqual((Object)iElementType, (Object)CMakeTokenTypes.LITERAL)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)TokenType.BAD_CHARACTER))) {
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)VAR_REFERENCE))) {
                int errorEnd;
                int errorStart;
                List children = node.getChildren();
                int offset = element.getTextOffset();
                if (children.size() == 0 || !Intrinsics.areEqual((Object)((Token)((TreeItem)children.get(0)).getData()).getType(), (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_START))) {
                    int n;
                    errorStart = offset + ((Token)node.getData()).getStart();
                    if (children.size() == 0) {
                        n = ((Token)node.getData()).getEnd();
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)children, (String)"children");
                        n = ((Token)((TreeItem)CollectionsKt.last((List)children)).getData()).getEnd();
                    }
                    errorEnd = n;
                    holder.newAnnotation(HighlightSeverity.ERROR, CMakeBundle.message("cmake.var.reference.expected.start", new Object[0])).range(new TextRange(errorStart, errorEnd)).create();
                }
                if (children.size() != 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)children, (String)"children");
                    if (!Intrinsics.areEqual((Object)((Token)((TreeItem)CollectionsKt.last((List)children)).getData()).getType(), (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_END))) {
                        errorStart = offset + ((Token)node.getData()).getStart();
                        errorEnd = offset + ((Token)((TreeItem)CollectionsKt.last((List)children)).getData()).getEnd();
                        Token startToken = !Intrinsics.areEqual((Object)((Token)((TreeItem)children.get(0)).getData()).getType(), (Object)((Object)CMakeVarReferenceLexer.VAR_REFERENCE_START)) ? null : (Token)((TreeItem)children.get(0)).getData();
                        Object[] objectArray = new Object[]{startToken == null || !Intrinsics.areEqual((Object)startToken.getText(), (Object)"@") ? "}" : "@"};
                        holder.newAnnotation(HighlightSeverity.ERROR, CMakeBundle.message("cmake.var.reference.expected.end", objectArray)).range(new TextRange(errorStart, errorEnd)).create();
                    }
                }
                for (TreeItem child : children) {
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    this.visit((TreeItem<Token>)child, element, holder);
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)COMPLEX_LITERAL))) {
                for (TreeItem child : node.getChildren()) {
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    this.visit((TreeItem<Token>)child, element, holder);
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)TokenType.ERROR_ELEMENT)) {
                int offset = element.getTextOffset();
                int errorStart = offset + ((Token)node.getData()).getStart();
                int errorEnd = ((Token)node.getData()).getEnd() >= element.getText().length() ? errorStart + 1 : offset + ((Token)node.getData()).getEnd();
                holder.newAnnotation(HighlightSeverity.ERROR, CMakeBundle.message("cmake.var.reference.incorrect", new Object[0])).range(new TextRange(errorStart, errorEnd)).create();
            } else {
                int offset = element.getTextOffset();
                int errorStart = offset + ((Token)node.getData()).getStart();
                int errorEnd = ((Token)node.getData()).getEnd() >= element.getText().length() ? errorStart + 1 : offset + ((Token)node.getData()).getEnd();
                holder.newAnnotation(HighlightSeverity.ERROR, CMakeBundle.message("cmake.var.reference.incorrect", new Object[0])).range(new TextRange(errorStart, errorEnd)).create();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cmake/psi/CMakeVarReferenceAnnotator$Companion;", "", "()V", "COMPLEX_LITERAL", "Lcom/jetbrains/cmake/psi/CMakeElementType;", "VAR_REFERENCE", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

