/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentManipulator;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakeFilePathPartsRenameHolder;
import com.jetbrains.cmake.psi.util.CMakeLiteralUtils;
import org.jetbrains.annotations.NotNull;

public class CMakeLiteralManipulator
extends AbstractElementManipulator<CMakeLiteral> {
    public CMakeLiteral handleContentChange(@NotNull CMakeLiteral element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        CMakeFilePathPartsRenameHolder filePathHolder = new CMakeFilePathPartsRenameHolder().invoke(element, range, newContent);
        String oldStart = filePathHolder.getOldStart();
        newContent = filePathHolder.getNewContent();
        String oldEnd = filePathHolder.getOldEnd();
        CMakeArgument elementParent = element.getArgument();
        if (elementParent.isBracketArgument()) {
            String newFullContent = "[[" + oldStart + newContent + oldEnd + "]]";
            CMakeArgument cMakeArgument = CMakeElementFactory.createArgumentRaw(element.getProject(), newFullContent);
            element.replace(cMakeArgument.getLiteralNotNull());
        } else {
            Object newFullContent = oldStart + (String)CMakeArgumentManipulator.ESCAPER.fun((Object)newContent) + oldEnd;
            if (CMakeLiteralUtils.shouldBeInsideQuotes((String)newFullContent)) {
                newFullContent = StringUtil.wrapWithDoubleQuote((String)newFullContent);
                CMakeArgument cMakeArgument = CMakeElementFactory.createArgumentRaw(element.getProject(), (CharSequence)newFullContent);
                if (!elementParent.isQuotedArgument() && !elementParent.isBracketArgument()) {
                    element.getParent().addBefore(cMakeArgument.getFirstChild(), (PsiElement)element);
                    element.getParent().addAfter(cMakeArgument.getLastChild(), (PsiElement)element);
                }
                element.replace(cMakeArgument.getLiteralNotNull());
            } else {
                element.replace(CMakeElementFactory.createArgumentRaw(element.getProject(), (CharSequence)newFullContent).getLiteralNotNull());
            }
        }
        return element;
    }
}

