/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeElementBase;
import com.jetbrains.cmake.psi.CMakeFileReferenceSet;
import com.jetbrains.cmake.psi.CMakeLiteralMixin;
import com.jetbrains.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cmake.resolve.CMakeRenameUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CMakeLiteralImplMixin
extends CMakeElementBase
implements CMakeLiteralMixin {
    public CMakeLiteralImplMixin(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        CMakeRenameUtils.renameArgument(this.getProject(), name, this.getNode());
        return this;
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public PsiReference @NotNull [] getReferences() {
        FileReferenceSet fileReferences = null;
        CMakeArgument cmakeArgument = this.getArgument();
        if (cmakeArgument != null && !cmakeArgument.isCommandDefinitionName() && !cmakeArgument.isEndCommandDefinitionName(this.getText())) {
            fileReferences = this.createFileReferencesSet();
        }
        Object[] contributed = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (fileReferences == null) {
            return contributed;
        }
        return (PsiReference[])ArrayUtil.mergeArrays((Object[])fileReferences.getAllReferences(), (Object[])contributed);
    }

    @NotNull
    public FileReferenceSet createFileReferencesSet() {
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)this);
        int offset = range.getStartOffset();
        String text = range.substring(this.getText());
        return new CMakeFileReferenceSet(text, this, offset, null, SystemInfo.isFileSystemCaseSensitive, false);
    }

    @Override
    public CMakeArgument getArgument() {
        return (CMakeArgument)PsiTreeUtil.getParentOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    public boolean equalByText(CMakeLiteralMixin cMakeLiteralMixin) {
        return CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)this, cMakeLiteralMixin);
    }
}

