/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cmake.formatting.CMakeCodeBlock;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeFormattingUtils {
    public static boolean textBetweenChildrenContainsLineBreak(@NotNull CMakeCodeBlock child1, @NotNull CMakeCodeBlock child2) {
        return CMakeFormattingUtils.textBetweenChildrenContainsLineBreak(child1.getNode(), child2.getNode());
    }

    public static boolean textBetweenChildrenContainsLineBreak(@NotNull ASTNode child1, @NotNull ASTNode child2) {
        PsiElement firstPsiElement = child1.getPsi();
        int to = child2.getTextRange().getStartOffset();
        PsiElement nextElement = firstPsiElement;
        while (nextElement != null && nextElement.getTextRange().getStartOffset() < to) {
            ASTNode nextElementNode;
            if ((nextElement = PsiTreeUtil.nextLeaf((PsiElement)nextElement)) == null || (nextElementNode = nextElement.getNode()).getElementType() != TokenType.WHITE_SPACE || !StringUtil.containsLineBreak((CharSequence)nextElementNode.getText())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> T rparShouldBeIndented(@NotNull CMakeCodeBlock parentNode, @NotNull ASTNode node, @Nullable T offset, @Nullable T zeroOffset) {
        if (node.getElementType() == CMakeTokenTypes.RPAR) {
            ASTNode parentAstNode = parentNode.getNode();
            ASTNode probableFirstArgument = parentAstNode.findChildByType(CMakeTokenTypes.C_MAKE_ARGUMENT);
            ASTNode probableFirstArgumentComment = parentAstNode.findChildByType(CMakeTokenTypes.COMMENT);
            ASTNode firstActualArgument = probableFirstArgument;
            if (probableFirstArgument == null) {
                firstActualArgument = probableFirstArgumentComment;
            } else if (probableFirstArgumentComment != null) {
                ASTNode aSTNode = firstActualArgument = probableFirstArgument.getStartOffset() < probableFirstArgumentComment.getStartOffset() ? probableFirstArgument : probableFirstArgumentComment;
            }
            if (firstActualArgument != null) {
                boolean leftParenthesisAndFirstArgumentAreOnTheSameLine;
                ASTNode whitespaceNode = parentAstNode.findChildByType(TokenType.WHITE_SPACE);
                boolean bl = leftParenthesisAndFirstArgumentAreOnTheSameLine = whitespaceNode == null || whitespaceNode.getStartOffset() >= firstActualArgument.getTextRange().getEndOffset() || !StringUtil.containsLineBreak((CharSequence)whitespaceNode.getText());
                if (parentAstNode.getElementType() == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS && leftParenthesisAndFirstArgumentAreOnTheSameLine) {
                    return offset;
                }
                return zeroOffset;
            }
        }
        return null;
    }
}

