/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.jetbrains.cmake.editor.CMakeFoldingBuilderKt;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeForeachCommand;
import com.jetbrains.cmake.psi.CMakeFunctionCommand;
import com.jetbrains.cmake.psi.CMakeIfCommand;
import com.jetbrains.cmake.psi.CMakeMacroCommand;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.CMakeVisitor;
import com.jetbrains.cmake.psi.CMakeWhileCommand;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001d\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cmake/editor/CMakeFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "()V", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "getLanguagePlaceholderText", "", "Lcom/intellij/openapi/util/NlsSafe;", "node", "Lcom/intellij/lang/ASTNode;", "range", "Lcom/intellij/openapi/util/TextRange;", "isRegionCollapsedByDefault", "Companion", "FoldingVisitor", "intellij.cmake.psi"})
public final class CMakeFoldingBuilder
extends CustomFoldingBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NlsSafe
    @NotNull
    private static final String DEFAULT_PLACEHOLDER_TEXT = "\u2026";
    @NlsSafe
    @NotNull
    public static final String CMAKE_MULTILINE_START = "#[[";
    @NlsSafe
    @NotNull
    public static final String CMAKE_MULTILINE_END = "]]";

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof CMakeFile)) {
            return;
        }
        FoldingVisitor visitor = new FoldingVisitor(descriptors);
        PsiTreeUtil.processElements((PsiElement)root, (PsiElementProcessor)new PsiElementProcessor(visitor){
            final /* synthetic */ FoldingVisitor $visitor;
            {
                this.$visitor = $visitor;
            }

            public final boolean execute(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.accept((PsiElementVisitor)this.$visitor);
                return true;
            }
        });
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (node.getPsi() instanceof PsiComment) {
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiComment");
            return CMakeFoldingBuilderKt.access$isMultilineComment((PsiComment)psiElement) ? "#[[ \u2026 ]]" : "# \u2026";
        }
        PsiElement psiElement = node.getPsi();
        CMakeElement cMakeElement = psiElement instanceof CMakeElement ? (CMakeElement)psiElement : null;
        if (cMakeElement == null) {
            return DEFAULT_PLACEHOLDER_TEXT;
        }
        CMakeElement cMakeElement2 = cMakeElement;
        boolean hasTerminator = CMakeFoldingBuilderKt.access$getHasTerminator(cMakeElement2);
        CMakeElement cMakeElement3 = cMakeElement2;
        if (cMakeElement3 instanceof CMakeCommand) {
            string2 = CMakeFoldingBuilderKt.access$getFoldedArguments((CMakeCommand)cMakeElement2);
        } else if (cMakeElement3 instanceof CMakeRoutine) {
            CMakeArgument cMakeArgument = ((CMakeRoutine)cMakeElement2).getFirstArgument();
            string2 = cMakeArgument != null ? cMakeArgument.getText() : null;
            if (string2 == null) {
                string2 = "";
            }
        } else {
            return DEFAULT_PLACEHOLDER_TEXT;
        }
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        String arguments = string3;
        String string4 = CMakeFoldingBuilderKt.access$getCommandName(cMakeElement2);
        if (string4 == null) {
            return DEFAULT_PLACEHOLDER_TEXT;
        }
        String commandName = string4;
        if (hasTerminator) {
            String string5 = CMakeFoldingBuilderKt.access$getClosingCommandNameWithArgs(cMakeElement2);
            if (string5 == null) {
                return DEFAULT_PLACEHOLDER_TEXT;
            }
            String commandEnd = string5;
            string = commandName + "(" + arguments + ") \u2026 " + commandEnd;
        } else {
            string = commandName + "(" + arguments + " \u2026)";
        }
        return string;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\b\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/cmake/editor/CMakeFoldingBuilder$FoldingVisitor;", "Lcom/jetbrains/cmake/psi/CMakeVisitor;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "(Ljava/util/List;)V", "allowFoldingNonTerminatedCommand", "", "o", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "findCommentBegin", "Lcom/intellij/psi/PsiElement;", "comment", "Lcom/intellij/psi/PsiComment;", "findCommentEnd", "foldBetween", "", "element", "right", "getEndOffset", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "shouldBeFoldedInComment", "elem", "forward", "visitCMakeCommand", "visitCMakeForeachCommand", "Lcom/jetbrains/cmake/psi/CMakeForeachCommand;", "visitCMakeFunctionCommand", "Lcom/jetbrains/cmake/psi/CMakeFunctionCommand;", "visitCMakeIfCommand", "Lcom/jetbrains/cmake/psi/CMakeIfCommand;", "visitCMakeMacroCommand", "Lcom/jetbrains/cmake/psi/CMakeMacroCommand;", "visitCMakeWhileCommand", "Lcom/jetbrains/cmake/psi/CMakeWhileCommand;", "visitComment", "intellij.cmake.psi"})
    public static final class FoldingVisitor
    extends CMakeVisitor {
        @NotNull
        private final List<FoldingDescriptor> descriptors;

        public FoldingVisitor(@NotNull List<FoldingDescriptor> descriptors) {
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            this.descriptors = descriptors;
        }

        @Override
        public void visitCMakeForeachCommand(@NotNull CMakeForeachCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            this.foldBetween(o, o.getCMakeEndForeachCommand());
        }

        @Override
        public void visitCMakeFunctionCommand(@NotNull CMakeFunctionCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            this.foldBetween(o, o.getCMakeEndFunctionCommand());
        }

        @Override
        public void visitCMakeMacroCommand(@NotNull CMakeMacroCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            this.foldBetween(o, o.getCMakeEndMacroCommand());
        }

        @Override
        public void visitCMakeWhileCommand(@NotNull CMakeWhileCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            this.foldBetween(o, o.getCMakeEndWhileCommand());
        }

        @Override
        public void visitCMakeIfCommand(@NotNull CMakeIfCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            PsiElement psiElement = o;
            List<CMakeCommand> list = o.getCMakeCommandList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"o.cMakeCommandList");
            this.foldBetween(psiElement, (PsiElement)CollectionsKt.lastOrNull(list));
        }

        private final boolean shouldBeFoldedInComment(PsiElement elem, boolean forward) {
            if (elem instanceof PsiComment && !CMakeFoldingBuilderKt.access$isMultilineComment((PsiComment)elem)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)elem), (Object)CMakeTokenTypes.EOL)) {
                PsiElement sibling = forward ? elem.getNextSibling() : elem.getPrevSibling();
                return sibling instanceof PsiComment && !CMakeFoldingBuilderKt.access$isMultilineComment((PsiComment)sibling);
            }
            return false;
        }

        private final PsiElement findCommentBegin(PsiComment comment) {
            return (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)comment), (boolean)false, (boolean)false, (int)2, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ FoldingVisitor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FoldingVisitor.access$shouldBeFoldedInComment(this.this$0, it, false);
                }
            })));
        }

        private final PsiElement findCommentEnd(PsiComment comment) {
            return (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)comment), (boolean)false, (boolean)false, (int)3, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ FoldingVisitor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FoldingVisitor.access$shouldBeFoldedInComment(this.this$0, it, true);
                }
            })));
        }

        public void visitComment(@NotNull PsiComment comment) {
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            if (CMakeFoldingBuilderKt.access$isMultilineComment(comment)) {
                this.foldBetween((PsiElement)comment, (PsiElement)comment);
            } else {
                PsiElement psiElement = this.findCommentBegin(comment);
                if (psiElement == null) {
                    return;
                }
                PsiElement firstNode = psiElement;
                PsiElement psiElement2 = this.findCommentEnd(comment);
                if (psiElement2 == null) {
                    return;
                }
                PsiElement lastNode = psiElement2;
                if (Intrinsics.areEqual((Object)firstNode, (Object)lastNode)) {
                    return;
                }
                this.foldBetween(firstNode, lastNode);
            }
        }

        @Override
        public void visitCMakeCommand(@NotNull CMakeCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (!CMakeFoldingBuilderKt.access$getHasTerminator(o) && this.allowFoldingNonTerminatedCommand(o)) {
                this.foldBetween(o, o);
            } else {
                super.visitCMakeCommand(o);
            }
        }

        private final boolean allowFoldingNonTerminatedCommand(CMakeCommand o) {
            return CMakePsiUtils.isSetCommand(o) || CMakePsiUtils.isListCommand(o);
        }

        private final Integer getEndOffset(PsiElement element) {
            Integer n;
            PsiElement psiElement = element;
            if (psiElement == null) {
                return null;
            }
            PsiElement elem = psiElement;
            PsiElement psiElement2 = elem;
            if (psiElement2 instanceof CMakeCommand) {
                CMakeCommandArguments cMakeCommandArguments = ((CMakeCommand)elem).getCMakeCommandArguments();
                n = cMakeCommandArguments != null ? Integer.valueOf(UtilsKt.getEndOffset((PsiElement)cMakeCommandArguments)) : null;
            } else {
                n = psiElement2 instanceof PsiComment ? Integer.valueOf(UtilsKt.getEndOffset((PsiElement)elem)) : null;
            }
            return n;
        }

        private final void foldBetween(PsiElement element, PsiElement right) {
            int startOffset = UtilsKt.getStartOffset((PsiElement)element);
            Integer n = this.getEndOffset(right);
            if (n == null) {
                return;
            }
            int endOffset = n;
            TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(startOffset, endOffset)");
            TextRange range = textRange;
            ((Collection)this.descriptors).add(new FoldingDescriptor(element.getNode(), range));
        }

        public static final /* synthetic */ boolean access$shouldBeFoldedInComment(FoldingVisitor $this, PsiElement elem, boolean forward) {
            return $this.shouldBeFoldedInComment(elem, forward);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cmake/editor/CMakeFoldingBuilder$Companion;", "", "()V", "CMAKE_MULTILINE_END", "", "CMAKE_MULTILINE_START", "DEFAULT_PLACEHOLDER_TEXT", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

