/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.lang.documentation.DocumentationResult;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.model.Pointer;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.suggested.UtilsKt;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.documentation.CMakeDocumentationPageProvider;
import com.jetbrains.cmake.documentation.CMakeDocumentationUsageCollector;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.documentation.CMakeElementDocumentationTargetPointer;
import com.jetbrains.cmake.documentation.DocumentationKind;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J0\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010$\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010&\u001a\u00020'H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget;", "Lcom/intellij/lang/documentation/DocumentationTarget;", "element", "Lcom/jetbrains/cmake/psi/CMakeElement;", "pageProvider", "Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;", "anchor", "", "(Lcom/jetbrains/cmake/psi/CMakeElement;Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;Ljava/lang/String;)V", "getAnchor", "()Ljava/lang/String;", "getElement", "()Lcom/jetbrains/cmake/psi/CMakeElement;", "getPageProvider", "()Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;", "pointer", "Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTargetPointer;", "checkCMakeLiteral", "Lkotlin/Pair;", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "literal", "Lcom/jetbrains/cmake/psi/CMakeLiteral;", "computeDocumentation", "Lcom/intellij/lang/documentation/DocumentationResult;", "createPointer", "isDirectoryProperty", "argument", "Lcom/jetbrains/cmake/psi/CMakeArgument;", "command", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "isGlobalProperty", "isModuleName", "isPolicyName", "isProperty", "isSourceFileProperty", "isTargetProperty", "isTestProperty", "isVariable", "presentation", "Lcom/intellij/navigation/TargetPresentation;", "Companion", "intellij.cmake.psi"})
public final class CMakeElementDocumentationTarget
implements DocumentationTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMakeElement element;
    @NotNull
    private final CMakeElementDocumentationTargetPointer pointer;
    @NotNull
    private static final Pair<String, DocumentationKind> EMPTY_PAIR = new Pair(null, null);

    public CMakeElementDocumentationTarget(@NotNull CMakeElement element, @NotNull CMakeDocumentationPageProvider pageProvider, @Nullable String anchor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)pageProvider, (String)"pageProvider");
        this.element = element;
        this.pointer = new CMakeElementDocumentationTargetPointer((Pointer<? extends CMakeElement>)((Pointer)UtilsKt.createSmartPointer((PsiElement)this.element)), pageProvider, anchor);
    }

    public /* synthetic */ CMakeElementDocumentationTarget(CMakeElement cMakeElement, CMakeDocumentationPageProvider cMakeDocumentationPageProvider, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(cMakeElement, cMakeDocumentationPageProvider, string);
    }

    @NotNull
    public final CMakeElement getElement() {
        return this.element;
    }

    @NotNull
    public final CMakeDocumentationPageProvider getPageProvider() {
        return this.pointer.getPageProvider();
    }

    private final String getAnchor() {
        return this.pointer.getAnchor();
    }

    @NotNull
    public CMakeElementDocumentationTargetPointer createPointer() {
        return this.pointer;
    }

    @NotNull
    public TargetPresentation presentation() {
        CMakeElement cMakeElement = this.element;
        Object object = cMakeElement instanceof PsiNamedElement ? (PsiNamedElement)cMakeElement : null;
        if (object == null || (object = object.getName()) == null) {
            object = this.element.getText();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(element as? PsiNamedEle\u2026nt)?.name ?: element.text");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder((String)object).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"TargetPresentation.build\u2026xt)\n      .presentation()");
        return targetPresentation;
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        Pair<String, DocumentationKind> pair;
        Logger $this$debug_u24default$iv = CMakePsiLog.INSTANCE.getLOG();
        CMakeElement e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Requested documentation for element: " + this.element, e$iv);
        }
        CMakeDocumentationUsageCollector.REQUESTED.log(this.element.getProject(), this.element.getClass());
        e$iv = this.element;
        if (e$iv instanceof CMakeCommand) {
            String string;
            String string2 = CMakePsiUtils.findCommandName((CMakeCommand)this.element);
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            } else {
                string = null;
            }
            pair = new Pair<String, DocumentationKind>((Object)string, (Object)DocumentationKind.COMMAND);
        } else if (e$iv instanceof CMakeCommandName) {
            String string = ((CMakeCommandName)this.element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name");
            String string4 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)string4, (Object)DocumentationKind.COMMAND);
        } else if (e$iv instanceof CMakeCommandNameMixin) {
            String string = ((CMakeCommandNameMixin)this.element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name");
            String string5 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)string5, (Object)DocumentationKind.COMMAND);
        } else {
            pair = e$iv instanceof CMakeLiteral ? this.checkCMakeLiteral((CMakeLiteral)this.element) : EMPTY_PAIR;
        }
        Pair<String, DocumentationKind> pair2 = pair;
        String name = (String)pair2.component1();
        DocumentationKind kind = (DocumentationKind)((Object)pair2.component2());
        if (name == null || kind == null) {
            return null;
        }
        Project project = this.element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Project project2 = project;
        return DocumentationResult.Companion.asyncDocumentation(() -> CMakeElementDocumentationTarget.computeDocumentation$lambda$2(this, name, kind, project2));
    }

    private final Pair<String, DocumentationKind> checkCMakeLiteral(CMakeLiteral literal) {
        String policy = this.isPolicyName(literal);
        if (policy != null) {
            return new Pair((Object)policy, (Object)DocumentationKind.POLICY);
        }
        String module = this.isModuleName(literal);
        if (module != null) {
            return new Pair((Object)module, (Object)DocumentationKind.MODULE);
        }
        Pair<String, DocumentationKind> pair = this.isProperty(literal);
        String property = (String)pair.component1();
        DocumentationKind kind = (DocumentationKind)((Object)pair.component2());
        if (property != null && kind != null) {
            return new Pair((Object)property, (Object)kind);
        }
        String variable = this.isVariable(literal);
        return new Pair((Object)variable, (Object)DocumentationKind.VARIABLE);
    }

    private final String isPolicyName(CMakeLiteral literal) {
        CMakeArgument argument = literal.getArgument();
        Intrinsics.checkNotNullExpressionValue((Object)argument, (String)"argument");
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand command = cMakeCommand;
        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.CMAKE_POLICY)) {
            return null;
        }
        CMakeArgument cMakeArgument = argument.getPreviousArgument();
        if (cMakeArgument == null) {
            return null;
        }
        CMakeArgument prevArgument = cMakeArgument;
        String prevArgumentText = prevArgument.getText();
        if (!StringsKt.equals((String)prevArgumentText, (String)"SET", (boolean)true) && !StringsKt.equals((String)prevArgumentText, (String)"GET", (boolean)true)) {
            return null;
        }
        if (prevArgument.getPreviousArgument() != null) {
            return null;
        }
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"literal.text");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string2;
    }

    private final String isModuleName(CMakeLiteral literal) {
        CMakeArgument argument = literal.getArgument();
        Intrinsics.checkNotNullExpressionValue((Object)argument, (String)"argument");
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand command = cMakeCommand;
        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.INCLUDE_COMMAND_NAME) && !CMakePsiUtils.isCommand(command, CMakeStandardCommands.FIND_PACKAGE)) {
            return null;
        }
        if (argument.getPreviousArgument() != null) {
            return null;
        }
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.INCLUDE_COMMAND_NAME)) {
            String text = literal.getText();
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            if (!StringsKt.contains$default((CharSequence)text, (CharSequence)"/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)".", (boolean)false, (int)2, null)) {
                return text;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.FIND_PACKAGE)) {
            return "Find" + literal.getText();
        }
        return null;
    }

    private final Pair<String, DocumentationKind> isProperty(CMakeLiteral literal) {
        Pair<String, DocumentationKind> pair;
        CMakeCommand command;
        CMakeArgument argument = literal.getArgument();
        Intrinsics.checkNotNullExpressionValue((Object)argument, (String)"argument");
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return EMPTY_PAIR;
        }
        CMakeCommand $this$isProperty_u24lambda_u243 = command = cMakeCommand;
        boolean bl = false;
        if (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) || CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.GET_PROPERTY)) {
            pair = this.isProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.GET_CMAKE_PROPERTY)) {
            pair = this.isGlobalProperty(literal, argument);
        } else if (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES) || CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) {
            pair = this.isDirectoryProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.SET_TARGET_PROPERTIES) || CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            pair = this.isTargetProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME) || CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            pair = this.isSourceFileProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.SET_TESTS_PROPERTIES) || CMakePsiUtils.isCommand($this$isProperty_u24lambda_u243, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            pair = this.isTestProperty(literal, argument, command);
        } else {
            return EMPTY_PAIR;
        }
        Pair<String, DocumentationKind> pair2 = pair;
        String name = (String)pair2.component1();
        DocumentationKind kind = (DocumentationKind)((Object)pair2.component2());
        if (name == null || kind == null) {
            return EMPTY_PAIR;
        }
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return new Pair((Object)string, (Object)kind);
    }

    private final Pair<String, DocumentationKind> isProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        DocumentationKind documentationKind;
        CMakeArgument kindArgument;
        CMakeArgument cMakeArgument = CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) ? command.getFirstArgument() : (kindArgument = CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_PROPERTY) ? CMakePsiUtils.secondArgument(command) : null);
        if (kindArgument == null) {
            return EMPTY_PAIR;
        }
        String string = kindArgument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kindArgument.text");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        switch (string2) {
            case "GLOBAL": {
                documentationKind = DocumentationKind.GLOBAL_PROPERTY;
                break;
            }
            case "DIRECTORY": {
                documentationKind = DocumentationKind.DIRECTORY_PROPERTY;
                break;
            }
            case "TARGET": {
                documentationKind = DocumentationKind.TARGET_PROPERTY;
                break;
            }
            case "SOURCE": {
                documentationKind = DocumentationKind.SOURCE_PROPERTY;
                break;
            }
            case "INSTALL": {
                documentationKind = DocumentationKind.INSTALL_PROPERTY;
                break;
            }
            case "TEST": {
                documentationKind = DocumentationKind.TEST_PROPERTY;
                break;
            }
            case "CACHE": {
                documentationKind = DocumentationKind.CACHE_PROPERTY;
                break;
            }
            default: {
                return EMPTY_PAIR;
            }
        }
        DocumentationKind kind = documentationKind;
        CMakeArgument prevArgument = argument.getPreviousArgument();
        if (prevArgument == null || !StringsKt.equals((String)prevArgument.getText(), (String)"PROPERTY", (boolean)true)) {
            return EMPTY_PAIR;
        }
        return new Pair((Object)literal.getText(), (Object)kind);
    }

    private final Pair<String, DocumentationKind> isGlobalProperty(CMakeLiteral literal, CMakeArgument argument) {
        if (CMakePsiUtils.isNotLastArgument(argument)) {
            return EMPTY_PAIR;
        }
        return new Pair((Object)literal.getText(), (Object)DocumentationKind.GLOBAL_PROPERTY);
    }

    private final Pair<String, DocumentationKind> isDirectoryProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.DIRECTORY_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.DIRECTORY_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final Pair<String, DocumentationKind> isTargetProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TARGET_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.TARGET_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.TARGET_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final Pair<String, DocumentationKind> isSourceFileProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.SOURCE_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.SOURCE_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final Pair<String, DocumentationKind> isTestProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TESTS_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.TEST_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            if (!CMakePsiUtils.isSecondArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.TEST_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final String isVariable(CMakeLiteral literal) {
        String text = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        if (CMakePsiUtils.isVariableRef(text)) {
            String string = CMakePsiUtils.stripVariableRef(text).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }
        String string = text.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string;
    }

    private static final DocumentationResult.Data computeDocumentation$lambda$2(CMakeElementDocumentationTarget this$0, String $name, DocumentationKind $kind, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        String string = this$0.getPageProvider().getDocumentationPage($name, $kind);
        if (string == null) {
            return null;
        }
        String page = string;
        Logger $this$debug_u24default$iv = CMakePsiLog.INSTANCE.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Showing documentation for element: " + this$0.element + ", anchor: " + this$0.getAnchor() + ", name: " + $name + ", kind: " + $kind, e$iv);
        }
        CMakeDocumentationUsageCollector.SHOWN.log($project, (Object)$kind, (Object)(this$0.getAnchor() != null ? 1 : 0));
        return DocumentationResult.Companion.documentation(page).anchor(this$0.getAnchor());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget$Companion;", "", "()V", "EMPTY_PAIR", "Lkotlin/Pair;", "", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

