/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.contributors.providers.CMakeQtDeprecatedCommands;
import com.jetbrains.cmake.psi.CMakeCommandName;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public enum CMakeStandardCommands {
    ELSE("else", true),
    ELSEIF("elseif", true),
    ENDFOREACH("endforeach", true),
    ENDFUNCTION("endfunction", true),
    ENDIF("endif", true),
    ENDMACRO("endmacro", true),
    ENDWHILE("endwhile", true),
    FOREACH("foreach", true),
    FUNCTION("function", true),
    IF("if", true),
    MACRO("macro", true),
    WHILE("while", true),
    ADD_COMPILE_OPTIONS("add_compile_options"),
    ADD_COMPILE_DEFINITIONS("add_compile_definitions"),
    ADD_CUSTOM_COMMAND("add_custom_command"),
    ADD_CUSTOM_TARGET_COMMAND_NAME("add_custom_target"),
    ADD_DEFINITIONS("add_definitions"),
    ADD_DEPENDENCIES("add_dependencies"),
    ADD_EXECUTABLE_COMMAND_NAME("add_executable"),
    ADD_LIBRARY_COMMAND_NAME("add_library"),
    ADD_LINK_OPTIONS("add_link_options"),
    ADD_SUBDIRECTORY("add_subdirectory"),
    ADD_TEST("add_test"),
    AUX_SOURCE_DIRECTORY("aux_source_directory"),
    BUILD_COMMAND("build_command"),
    CMAKE_HOST_SYSTEM_INFORMATION("cmake_host_system_information"),
    CMAKE_LANGUAGE("cmake_language"),
    CMAKE_MINIMUM_REQUIRED("cmake_minimum_required"),
    CMAKE_PARSE_ARGUMENTS("cmake_parse_arguments"),
    CMAKE_PATH("cmake_path"),
    CMAKE_POLICY("cmake_policy"),
    CONFIGURE_FILE("configure_file"),
    CREATE_TEST_SOURCELIST("create_test_sourcelist"),
    DEFINE_PROPERTY("define_property"),
    ENABLE_LANGUAGE("enable_language"),
    ENABLE_TESTING("enable_testing"),
    EXECUTE_PROCESS("execute_process"),
    EXPORT("export"),
    FILE("file"),
    FIND_FILE("find_file"),
    FIND_LIBRARY("find_library"),
    FIND_PACKAGE("find_package"),
    FIND_PATH("find_path"),
    FIND_PROGRAM("find_program"),
    FLTK_WRAP_UI_COMMAND_NAME("fltk_wrap_ui"),
    GET_CMAKE_PROPERTY("get_cmake_property"),
    GET_DIRECTORY_PROPERTY("get_directory_property"),
    GET_FILENAME_COMPONENT("get_filename_component"),
    GET_PROPERTY("get_property"),
    GET_SOURCE_FILE_PROPERTY("get_source_file_property"),
    GET_TARGET_PROPERTY("get_target_property"),
    GET_TEST_PROPERTY("get_test_property"),
    INCLUDE_DIRECTORIES("include_directories"),
    INCLUDE_EXTERNAL_MSPROJECT("include_external_msproject"),
    INCLUDE_GUARD("include_guard"),
    INCLUDE_REGULAR_EXPRESSION("include_regular_expression"),
    INCLUDE_COMMAND_NAME("include"),
    INSTALL("install"),
    LINK_DIRECTORIES("link_directories"),
    LINK_LIBRARIES("link_libraries"),
    LIST("list"),
    LOAD_CACHE("load_cache"),
    MARK_AS_ADVANCED("mark_as_advanced"),
    MATH("math"),
    MESSAGE("message"),
    OPTION("option"),
    PROJECT("project"),
    REMOVE_DEFINITIONS("remove_definitions"),
    RETURN("return"),
    SEPARATE_ARGUMENTS("separate_arguments"),
    SET_DIRECTORY_PROPERTIES("set_directory_properties"),
    SET_PROPERTY_COMMAND_NAME("set_property"),
    SET_COMMAND_NAME("set"),
    SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME("set_source_files_properties"),
    SET_TARGET_PROPERTIES("set_target_properties"),
    SET_TESTS_PROPERTIES("set_tests_properties"),
    SITE_NAME("site_name"),
    SOURCE_GROUP("source_group"),
    STRING("string"),
    TARGET_COMPILE_DEFINITIONS("target_compile_definitions"),
    TARGET_COMPILE_FEATURES("target_compile_features"),
    TARGET_COMPILE_OPTIONS("target_compile_options"),
    TARGET_INCLUDE_DIRECTORIES("target_include_directories"),
    TARGET_LINK_DIRECTORIES("target_link_directories"),
    TARGET_LINK_LIBRARIES("target_link_libraries"),
    TARGET_LINK_OPTIONS("target_link_options"),
    TARGET_PRECOMPILE_HEADERS("target_precompile_headers"),
    TARGET_SOURCES("target_sources"),
    TRY_COMPILE_COMMAND_NAME("try_compile"),
    TRY_RUN("try_run"),
    UNSET("unset"),
    VARIABLE_WATCH("variable_watch");

    @NonNls
    private static final Set<String> DEPRECATED_COMMANDS;
    @TestOnly
    @NonNls
    private static final Set<String> CTEST_NO_COMPLETION;
    @TestOnly
    @NonNls
    public static final Set<String> NO_COMPLETION;
    @NonNls
    private final String myCommandName;
    private final boolean myLexerToken;

    private CMakeStandardCommands(String commandName) {
        this(commandName, false);
    }

    private CMakeStandardCommands(String commandName, boolean lexerToken) {
        this.myCommandName = commandName;
        this.myLexerToken = lexerToken;
    }

    public boolean isLexerToken() {
        return this.myLexerToken;
    }

    @NonNls
    public String getCommandName() {
        return this.myCommandName;
    }

    public static boolean isDeprecated(@NotNull CMakeCommandName cMakeCommandName) {
        String name = StringUtil.toLowerCase((String)cMakeCommandName.getName());
        return DEPRECATED_COMMANDS.contains(name);
    }

    public static boolean isCommand(CMakeStandardCommands command, CMakeCommandName cMakeCommandName) {
        return command.getCommandName().equalsIgnoreCase(cMakeCommandName.getName());
    }

    public static boolean isCommand(CMakeQtDeprecatedCommands command, CMakeCommandName cMakeCommandName) {
        return command.getCommandName().equalsIgnoreCase(cMakeCommandName.getName());
    }

    static {
        DEPRECATED_COMMANDS = Set.of("build_name", "exec_program", "export_library_dependencies", "install_files", "install_programs", "install_targets", "load_command", "make_directory", "output_required_files", "qt_wrap_cpp", "qt_wrap_ui", "remove", "subdir_depends", "subdirs", "use_mangled_mesa", "utility_source", "variable_requires", "write_file");
        CTEST_NO_COMPLETION = Set.of("ctest_build", "ctest_configure", "ctest_coverage", "ctest_empty_binary_directory", "ctest_memcheck", "ctest_read_custom_files", "ctest_run_script", "ctest_sleep", "ctest_start", "ctest_submit", "ctest_test", "ctest_update", "ctest_upload");
        NO_COMPLETION = ContainerUtil.union(CTEST_NO_COMPLETION, DEPRECATED_COMMANDS);
    }
}

