/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.completion.contributors.providers.AbstractCMakeCompletionProvider;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.Case;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCMakeCaseSensitiveCompletionProvider
extends AbstractCMakeCompletionProvider {
    protected final List<String> myVariants;
    private final boolean myBoldCompletion;
    private final boolean myPutCaretInsideParentheses;

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords) {
        this(completionWords, false);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords, boolean boldCompletion) {
        this(completionWords, boldCompletion, true);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this(Arrays.asList(completionWords), boldCompletion, putCaretInsideParentheses);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(IElementType[] completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this(ContainerUtil.map((Object[])completionWords, type -> type.toString()), boldCompletion, putCaretInsideParentheses);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(List<String> completionWords) {
        this(completionWords, false, true);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(List<String> completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this.myVariants = completionWords;
        this.myBoldCompletion = boldCompletion;
        this.myPutCaretInsideParentheses = putCaretInsideParentheses;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        CMakeCodeStyleSettings settings = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parameters.getOriginalFile(), CMakeCodeStyleSettings.class);
        Case keywordCase = Case.resolveByValue(AbstractCMakeCaseSensitiveCompletionProvider.getCaseVariableValue(settings));
        String stringToComplete = parameters.getPosition().getText().replace("IntellijIdeaRulezzz", "");
        boolean toUpper = keywordCase == Case.TO_UPPER || keywordCase == Case.DO_NOT_CHANGE && stringToComplete.length() > 0 && Character.isUpperCase(stringToComplete.charAt(0));
        result.caseInsensitive().addAllElements((Iterable)ContainerUtil.map(this.myVariants, s -> CMakeCompletionUtils.createStandardCommandItem(toUpper ? StringUtil.toUpperCase((String)s) : s, this.myBoldCompletion, this.myPutCaretInsideParentheses, Collections.emptyList())));
    }

    private static int getCaseVariableValue(@NotNull CMakeCodeStyleSettings settings) {
        return settings.FORCE_COMMANDS_CASE;
    }
}

