/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cmake.completion.contributors.CMakeCommandArgumentCompletionContributor;
import com.jetbrains.cmake.completion.contributors.CMakeCommandCompletionContributor;
import com.jetbrains.cmake.completion.contributors.CMakeKeywordCompletionContributor;
import com.jetbrains.cmake.completion.contributors.CMakeModuleCompletionContributor;
import com.jetbrains.cmake.completion.contributors.CMakeVariableCompletionContributor;
import com.jetbrains.cmake.psi.CMakeVariableReference;
import org.jetbrains.annotations.NotNull;

public class CMakeCompletionContributor
extends CompletionContributor {
    public CMakeCompletionContributor() {
        new CMakeKeywordCompletionContributor().extendContributor(this);
        new CMakeCommandCompletionContributor().extendContributor(this);
        new CMakeVariableCompletionContributor().extendContributor(this);
        new CMakeModuleCompletionContributor().extendContributor(this);
        new CMakeCommandArgumentCompletionContributor().extendContributor(this);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        super.beforeCompletion(context);
        PsiElement position = context.getFile().findElementAt(context.getStartOffset());
        CMakeVariableReference varRef = (CMakeVariableReference)PsiTreeUtil.getParentOfType((PsiElement)position, CMakeVariableReference.class, (boolean)true);
        if (varRef != null) {
            context.setReplacementOffset(varRef.getTextRange().getEndOffset());
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        return CMakeVariableCompletionContributor.shouldAutoPopup(position, typeChar);
    }
}

