/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.jetbrains.cmake.CMakeBundle;
import icons.CMakeIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPNewCMakeListsFileAction
extends CreateFromTemplateActionBase
implements DumbAware {
    public static final String ID = "CPP.NewCMakeListsFile";
    private static final String CMAKE_LISTS_TEMPLATE_NAME = "CMakeLists.txt";

    public CPPNewCMakeListsFileAction() {
        super(CMakeBundle.messagePointer("cmake.action.newCMakeLists.title", new Object[0]), CMakeBundle.messagePointer("cmake.action.newCMakeLists.title", new Object[0]), CMakeIcons.CMake);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(CPPNewCMakeListsFileAction.isAvailable(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static boolean isAvailable(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return false;
        }
        return view.getDirectories().length >= 1;
    }

    protected FileTemplate getTemplate(Project project, PsiDirectory dir) {
        return FileTemplateManager.getInstance((Project)project).getInternalTemplate(CMAKE_LISTS_TEMPLATE_NAME);
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        PsiDirectory directory = super.getTargetDirectory(dataContext, view);
        if (directory == null) {
            return null;
        }
        PsiFile cmakeListsFile = directory.findFile(CMAKE_LISTS_TEMPLATE_NAME);
        if (cmakeListsFile != null) {
            Messages.showErrorDialog((Project)((Project)CommonDataKeys.PROJECT.getData(dataContext)), (String)CMakeBundle.message("cmake.action.newCMakeLists.error.description", directory.getVirtualFile().getPath()), (String)CMakeBundle.message("cmake.action.newCMakeLists.error", new Object[0]));
            return null;
        }
        return directory;
    }

    @Nullable
    protected AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        return new AttributesDefaults(CMAKE_LISTS_TEMPLATE_NAME).withFixedName(true);
    }

    public boolean isDumbAware() {
        return true;
    }
}

