/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.zipcache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 5*\u0006\b\u0000\u0010\u0001 \u0000*\u0006\b\u0001\u0010\u0002 \u0001*\u0006\b\u0002\u0010\u0003 \u00002\u00020\u0004:\u00015B\u0017\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000bH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u0006H\u0007J\u0016\u0010 \u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0006H\u0002J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060'H\u0003J\u0017\u0010(\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010+\u001a\u00020,H\u0003J\u0006\u0010-\u001a\u00020\u001cJ\u001f\u0010.\u001a\u0004\u0018\u00018\u00012\u0006\u0010/\u001a\u00020\u000b2\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020\u001cH\u0002J\u0018\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\f\u00104\u001a\u00020\u0006*\u00020\u0006H\u0004R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u00066"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache;", "Key", "Value", "CachingValue", "", "zipFileName", "", "zipCacheVersion", "", "(Ljava/lang/String;I)V", "myZipCacheRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "resourcesFolder", "getResourcesFolder", "()Ljava/lang/String;", "shouldBeTested", "", "getShouldBeTested", "()Z", "zipCacheRoot", "getZipCacheRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getZipCacheVersion", "()I", "getZipFileName", "checkZipIsAcceptable", "zipVirtualFile", "disableZipCacheRootInTests", "", "disposableParent", "Lcom/intellij/openapi/Disposable;", "getDownloadedFolder", "getInstalledCacheRoot", "installedCacheParentFolderOverride", "getRelativePath", "Ljava/nio/file/Path;", "key", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "getResourceFolders", "", "getValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "getZipVirtualFile", "zip", "Ljava/io/File;", "initializeInstalledCache", "readValue", "dir", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)Ljava/lang/Object;", "restoreZipCacheRootInTests", "setZipCacheRootInTests", "path", "withVersion", "Companion", "intellij.cidr.util"})
public abstract class CidrZipBackedCache<Key, Value, CachingValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String zipFileName;
    private final int zipCacheVersion;
    @Nullable
    private volatile VirtualFile myZipCacheRoot;
    @NotNull
    public static final String AUTOMATICALLY_DOWNLOAD_KEY = "com.jetbrains.cidr.ZipCacheDownloader.shouldDownload";
    @JvmField
    public static volatile boolean buildingCache;
    @NotNull
    private static final Logger LOG;

    public CidrZipBackedCache(@Nullable String zipFileName, int zipCacheVersion) {
        this.zipFileName = zipFileName;
        this.zipCacheVersion = zipCacheVersion;
        this.initializeInstalledCache();
    }

    @Nullable
    public final String getZipFileName() {
        return this.zipFileName;
    }

    public final int getZipCacheVersion() {
        return this.zipCacheVersion;
    }

    @Nullable
    public final VirtualFile getZipCacheRoot() {
        return this.myZipCacheRoot;
    }

    private final VirtualFile getInstalledCacheRoot(String installedCacheParentFolderOverride) {
        Object v0;
        block6: {
            if (this.zipFileName == null) {
                return null;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().assertIsDispatchThread();
            }
            List possibleLocations = installedCacheParentFolderOverride != null ? CollectionsKt.listOf((Object)installedCacheParentFolderOverride) : CollectionsKt.plus((Collection)this.getResourceFolders(), (Object)this.getDownloadedFolder());
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possibleLocations), (Function1)((Function1)new Function1<String, File>(this){
                final /* synthetic */ CidrZipBackedCache<Key, Value, CachingValue> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final File invoke(@NotNull String it) {
                    return new File(it, this.this$0.getZipFileName());
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        File file = v0;
        if (file == null) {
            return null;
        }
        File zip2 = file;
        boolean $i$f$runWriteAction = false;
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction(new Computable(this, zip2){
            final /* synthetic */ CidrZipBackedCache this$0;
            final /* synthetic */ File $zip$inlined;
            {
                this.this$0 = cidrZipBackedCache;
                this.$zip$inlined = file;
            }

            public final T compute() {
                boolean bl = false;
                return (T)CidrZipBackedCache.access$getZipVirtualFile(this.this$0, this.$zip$inlined);
            }
        });
        if (virtualFile == null) {
            return null;
        }
        VirtualFile zipVirtualFile = virtualFile;
        if (!this.checkZipIsAcceptable(zipVirtualFile)) {
            return null;
        }
        return zipVirtualFile;
    }

    static /* synthetic */ VirtualFile getInstalledCacheRoot$default(CidrZipBackedCache cidrZipBackedCache, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getInstalledCacheRoot");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return cidrZipBackedCache.getInstalledCacheRoot(string);
    }

    protected boolean checkZipIsAcceptable(@NotNull VirtualFile zipVirtualFile) {
        return true;
    }

    @RequiresWriteLock
    private final VirtualFile getZipVirtualFile(File zip2) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)zip2, (boolean)true);
        if (virtualFile == null) {
            CidrZipBackedCache $this$getZipVirtualFile_u24lambda_u242 = this;
            boolean bl = false;
            LOG.error("Failed to get virtual file of " + $this$getZipVirtualFile_u24lambda_u242.zipFileName);
            return null;
        }
        VirtualFile zipVF = virtualFile;
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(zipVF);
        if (virtualFile2 == null) {
            CidrZipBackedCache $this$getZipVirtualFile_u24lambda_u243 = this;
            boolean bl = false;
            LOG.error("Failed to get jar root for " + $this$getZipVirtualFile_u24lambda_u243.zipFileName);
            return null;
        }
        VirtualFile cacheRoot = virtualFile2;
        LOG.info(this.getClass().getSimpleName() + " uses zip cache " + cacheRoot.getCanonicalPath());
        return cacheRoot;
    }

    @NonNls
    private final List<String> getResourceFolders() {
        List list;
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (bl) {
            Object[] objectArray = new String[]{PathManager.getSystemPath(), this.getResourcesFolder()};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (!bl) {
            list = CollectionsKt.listOf((Object)this.getResourcesFolder());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public final String getResourcesFolder() {
        String[] stringArray = new String[]{PathManager.getHomePath(), "Resources"};
        return FileUtil.join((String[])stringArray);
    }

    @NonNls
    @NotNull
    public final String getDownloadedFolder() {
        String[] stringArray = new String[]{PathManager.getSystemPath(), "DownloadedCaches"};
        return this.withVersion(FileUtil.join((String[])stringArray));
    }

    public final void initializeInstalledCache() {
        ApplicationManager.getApplication().invokeAndWait(() -> CidrZipBackedCache.initializeInstalledCache$lambda$4(this));
    }

    @Nullable
    public Value getValue(Key key) {
        VirtualFile virtualFile = this.getZipCacheRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        Path path = this.getRelativePath(key);
        if (path == null) {
            return null;
        }
        Path path2 = path;
        VirtualFile virtualFile2 = root.findFileByRelativePath(((Object)path2).toString());
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile cacheDir = virtualFile2;
        return this.readValue(cacheDir, key);
    }

    @Nullable
    protected abstract Path getRelativePath(Key var1);

    @Nullable
    protected abstract Value readValue(@NotNull VirtualFile var1, Key var2);

    @NotNull
    protected final String withVersion(@NotNull String $this$withVersion) {
        String string;
        if (this.zipCacheVersion == 1) {
            string = $this$withVersion;
        } else {
            String[] stringArray = new String[]{$this$withVersion, String.valueOf(this.zipCacheVersion)};
            string = FileUtil.join((String[])stringArray);
        }
        return string;
    }

    @TestOnly
    public boolean getShouldBeTested() {
        return true;
    }

    @TestOnly
    public final void setZipCacheRootInTests(@NotNull String path, @NotNull Disposable disposableParent) {
        Disposer.register((Disposable)disposableParent, this::restoreZipCacheRootInTests);
        ApplicationManager.getApplication().invokeAndWait(() -> CidrZipBackedCache.setZipCacheRootInTests$lambda$5(this, path));
    }

    @TestOnly
    public final void disableZipCacheRootInTests(@NotNull Disposable disposableParent) {
        Disposer.register((Disposable)disposableParent, this::restoreZipCacheRootInTests);
        ApplicationManager.getApplication().invokeAndWait(() -> CidrZipBackedCache.disableZipCacheRootInTests$lambda$6(this));
    }

    private final void restoreZipCacheRootInTests() {
        this.initializeInstalledCache();
    }

    private static final void initializeInstalledCache$lambda$4(CidrZipBackedCache this$0) {
        this$0.myZipCacheRoot = CidrZipBackedCache.getInstalledCacheRoot$default(this$0, null, 1, null);
    }

    private static final void setZipCacheRootInTests$lambda$5(CidrZipBackedCache this$0, String $path) {
        this$0.myZipCacheRoot = this$0.getInstalledCacheRoot($path);
    }

    private static final void disableZipCacheRootInTests$lambda$6(CidrZipBackedCache this$0) {
        this$0.myZipCacheRoot = null;
    }

    public static final /* synthetic */ VirtualFile access$getZipVirtualFile(CidrZipBackedCache $this, File zip2) {
        return $this.getZipVirtualFile(zip2);
    }

    static {
        LOG = Logger.getInstance(CidrZipBackedCache.class);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache$Companion;", "", "()V", "AUTOMATICALLY_DOWNLOAD_KEY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "buildingCache", "", "intellij.cidr.util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

