/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.zipcache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0006\b\u0001\u0010\u0002 \u0001*\u0006\b\u0002\u0010\u0003 \u00002\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0017\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\"J\u0017\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0007J\u001d\u0010.\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010\u001eJ%\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0002H$\u00a2\u0006\u0002\u00100R\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrWritableZipBackedCache;", "Key", "Value", "CachingValue", "Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache;", "Lkotlinx/coroutines/CoroutineScope;", "relativeCachePath", "", "zipFileName", "zipCacheVersion", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "cacheRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCacheRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cacheRootPath", "Ljava/nio/file/Path;", "getCacheRootPath", "()Ljava/nio/file/Path;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "myCacheRoot", "myCacheRootInTests", "cacheValue", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "findExistingVirtualFileParent", "path", "getCacheDir", "(Ljava/lang/Object;)Lcom/intellij/openapi/vfs/VirtualFile;", "getPathForCaching", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "getValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "markDirectoryDirty", "prepareRoot", "registerRootOnEDT", "relativeOrAbsoluteCachePath", "setCacheRootToTempDirInTests", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "writeValue", "dir", "(Ljava/nio/file/Path;Ljava/lang/Object;Ljava/lang/Object;)V", "intellij.cidr.util"})
public abstract class CidrWritableZipBackedCache<Key, Value, CachingValue>
extends CidrZipBackedCache<Key, Value, CachingValue>
implements CoroutineScope {
    @NotNull
    private final CoroutineContext coroutineContext = (CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null);
    @Nullable
    private final VirtualFile myCacheRoot;
    @Nullable
    private VirtualFile myCacheRootInTests;

    public CidrWritableZipBackedCache(@NotNull String relativeCachePath, @Nullable String zipFileName, int zipCacheVersion) {
        super(zipFileName, zipCacheVersion);
        String path = this.withVersion(relativeCachePath);
        this.myCacheRootInTests = this.myCacheRoot = this.registerRootOnEDT(path);
    }

    @NotNull
    public final CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Nullable
    public final VirtualFile getCacheRoot() {
        return ApplicationManager.getApplication().isUnitTestMode() ? this.myCacheRootInTests : this.myCacheRoot;
    }

    @Nullable
    public final Path getCacheRootPath() {
        VirtualFile virtualFile = this.getCacheRoot();
        return virtualFile != null ? virtualFile.toNioPath() : null;
    }

    @Override
    @Nullable
    public Value getValue(Key key) {
        Object Value = super.getValue(key);
        if (Value != null) {
            Object it = Value;
            boolean bl = false;
            return it;
        }
        VirtualFile virtualFile = this.getCacheDir(key);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile cacheDir = virtualFile;
        return this.readValue(cacheDir, key);
    }

    private final VirtualFile registerRootOnEDT(String relativeOrAbsoluteCachePath) {
        String string;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsoluteCachePath)) {
            string = relativeOrAbsoluteCachePath;
        } else {
            String[] stringArray = new String[]{PathManager.getSystemPath(), relativeOrAbsoluteCachePath};
            string = FileUtil.join((String[])stringArray);
        }
        String path = string;
        new File(path).mkdirs();
        return (VirtualFile)WriteAction.computeAndWait(() -> CidrWritableZipBackedCache.registerRootOnEDT$lambda$1(this, path));
    }

    private final VirtualFile prepareRoot(String path) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        try {
            VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            if (dir != null) {
                return dir;
            }
        }
        catch (IOException error) {
            CidrZipBackedCache.Companion.getLOG().error((Throwable)error);
        }
        return null;
    }

    @TestOnly
    public final void setCacheRootToTempDirInTests(@NotNull Disposable testRootDisposable) {
        ApplicationManager.getApplication().invokeAndWait(() -> CidrWritableZipBackedCache.setCacheRootToTempDirInTests$lambda$2(this));
        Disposer.register((Disposable)testRootDisposable, () -> CidrWritableZipBackedCache.setCacheRootToTempDirInTests$lambda$5(this));
    }

    public final void cacheValue(Key key, CachingValue value) {
        this.writeValue(key, value);
    }

    protected abstract void writeValue(@NotNull Path var1, Key var2, CachingValue var3);

    private final void writeValue(Key key, CachingValue value) {
        Path path = this.getPathForCaching(key);
        if (path == null) {
            return;
        }
        Path dir = path;
        this.writeValue(dir, key, value);
        this.markDirectoryDirty(dir);
    }

    private final void markDirectoryDirty(Path path) {
        VirtualFile virtualFile = this.findExistingVirtualFileParent(path);
        if (virtualFile == null) {
            return;
        }
        VirtualFile parent = virtualFile;
        VirtualFile[] virtualFileArray = new VirtualFile[]{parent};
        VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
    }

    private final VirtualFile findExistingVirtualFileParent(Path path) {
        VirtualFile virtualFile = this.getCacheRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile;
        for (Path part : path) {
            VirtualFile child;
            if (parent.findChild(((Object)part).toString()) == null) {
                return parent;
            }
            parent = child;
        }
        return parent;
    }

    private final VirtualFile getCacheDir(Key key) {
        Path path = this.getPathForCaching(key);
        if (path == null) {
            return null;
        }
        Path pathForCaching = path;
        return VfsUtil.findFile((Path)pathForCaching, (boolean)false);
    }

    private final Path getPathForCaching(Key key) {
        Path path = this.getCacheRootPath();
        if (path == null) {
            return null;
        }
        Path basePath = path;
        Path path2 = this.getRelativePath(key);
        if (path2 == null) {
            return null;
        }
        Path relativePath = path2;
        return basePath.resolve(relativePath);
    }

    private static final VirtualFile registerRootOnEDT$lambda$1(CidrWritableZipBackedCache this$0, String $path) {
        return this$0.prepareRoot($path);
    }

    private static final void setCacheRootToTempDirInTests$lambda$2(CidrWritableZipBackedCache this$0) {
        String path = FileUtil.createTempDirectory((String)"cidr_test_", null, (boolean)false).getCanonicalPath();
        this$0.myCacheRootInTests = this$0.registerRootOnEDT(path);
    }

    private static final void setCacheRootToTempDirInTests$lambda$5$lambda$4(CidrWritableZipBackedCache this$0) {
        Object object = this$0.myCacheRootInTests;
        if (object != null && (object = object.getCanonicalPath()) != null) {
            Object path = object;
            boolean bl = false;
            FileUtil.delete((File)new File((String)path));
        }
        this$0.myCacheRootInTests = this$0.myCacheRoot;
    }

    private static final void setCacheRootToTempDirInTests$lambda$5(CidrWritableZipBackedCache this$0) {
        ApplicationManager.getApplication().invokeAndWait(() -> CidrWritableZipBackedCache.setCacheRootToTempDirInTests$lambda$5$lambda$4(this$0));
    }
}

