/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.execution.ui.ProgramInputRedirectPanel;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.ConsoleOptions;
import com.jetbrains.cidr.execution.ElevationOptions;
import com.jetbrains.cidr.ui.CidrEnvironmentVariablesComponent;
import com.jetbrains.cidr.ui.ConsoleOptionsPanel;
import com.jetbrains.cidr.ui.ElevationPanel;
import java.awt.Component;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CidrProgramParametersPanel
extends CommonProgramParametersPanel {
    protected ProgramInputRedirectPanel myProgramInputRedirectPanel;
    protected ElevationPanel myElevationPanel;
    protected ConsoleOptionsPanel myConsoleOptionsPanel;

    public CidrProgramParametersPanel() {
        this(true);
    }

    public CidrProgramParametersPanel(boolean init) {
        super(init);
    }

    protected void initComponents() {
        this.myProgramInputRedirectPanel = new ProgramInputRedirectPanel();
        this.myElevationPanel = new ElevationPanel();
        this.myConsoleOptionsPanel = new ConsoleOptionsPanel();
        if (!CidrProgramParametersPanel.isExternalConsoleSupportEnabled()) {
            this.myConsoleOptionsPanel.setVisible(false);
        }
        super.initComponents();
    }

    @NotNull
    protected EnvironmentVariablesComponent createEnvironmentVariablesComponent() {
        return new CidrEnvironmentVariablesComponent();
    }

    protected void addComponents() {
        super.addComponents();
        this.add((Component)this.myProgramInputRedirectPanel);
        this.add(this.myElevationPanel);
        this.add(this.myConsoleOptionsPanel);
    }

    protected final boolean isMacroSupportEnabled() {
        return true;
    }

    private static boolean isExternalConsoleSupportEnabled() {
        return SystemInfo.isWindows;
    }

    @NotNull
    protected Predicate<? super Macro> getCommonMacroFilter() {
        return m -> !m.getName().startsWith("CMake");
    }

    protected void initMacroSupport() {
        super.initMacroSupport();
        this.addMacroSupport((ExtendableTextField)this.myProgramInputRedirectPanel.getComponent().getTextField(), MacrosDialog.Filters.FILE_PATH);
    }

    public void setAnchor(JComponent labelAnchor) {
        super.setAnchor(labelAnchor);
        this.myProgramInputRedirectPanel.setAnchor(labelAnchor);
        this.myElevationPanel.setAnchor(labelAnchor);
        this.myConsoleOptionsPanel.setAnchor(labelAnchor);
    }

    protected void setupAnchor() {
        super.setupAnchor();
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this, this.myProgramInputRedirectPanel});
    }

    public void setOwnComponentsVisibility(boolean visible) {
        this.myElevationPanel.setVisible(visible);
        this.myProgramInputRedirectPanel.setVisible(visible);
        if (CidrProgramParametersPanel.isExternalConsoleSupportEnabled()) {
            this.myConsoleOptionsPanel.setVisible(visible);
        }
    }

    public void applyTo(@NotNull CommonProgramRunConfigurationParameters configuration) {
        super.applyTo(configuration);
        if (configuration instanceof InputRedirectAware.InputRedirectOptions && this.myProgramInputRedirectPanel.isVisible()) {
            this.myProgramInputRedirectPanel.applyTo((InputRedirectAware.InputRedirectOptions)configuration);
        }
        if (configuration instanceof ElevationOptions && this.myElevationPanel.isVisible()) {
            this.myElevationPanel.applyTo((ElevationOptions)configuration);
        }
        if (configuration instanceof ConsoleOptions && this.myConsoleOptionsPanel.isVisible()) {
            this.myConsoleOptionsPanel.applyTo((ConsoleOptions)configuration);
        }
    }

    public void reset(@NotNull CommonProgramRunConfigurationParameters configuration) {
        super.reset(configuration);
        if (configuration instanceof InputRedirectAware.InputRedirectOptions) {
            this.myProgramInputRedirectPanel.reset((InputRedirectAware.InputRedirectOptions)configuration);
        }
        if (configuration instanceof ElevationOptions) {
            this.myElevationPanel.reset((ElevationOptions)configuration);
        }
        if (configuration instanceof ConsoleOptions) {
            this.myConsoleOptionsPanel.reset((ConsoleOptions)configuration);
        }
    }
}

