/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolsUtil {
    private static final Logger LOG = Logger.getInstance(CidrToolsUtil.class);
    public static final int PATH_CACHE_SIZE = 10000;

    public static boolean checkSuccess(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output, @NotNull Logger logger) {
        if (output.getExitCode() == 0 && !output.isTimeout()) {
            return true;
        }
        logger.info(CidrToolsUtil.logInfo(cl, output));
        return false;
    }

    @NotNull
    public static String logInfo(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output) {
        return "[" + cl.getCommandLineString() + "]: " + CidrToolsUtil.extractError(output);
    }

    @NotNull
    public static String extractError(@NotNull ProcessOutput output) {
        StringBuilder sb = new StringBuilder();
        if (output.isTimeout()) {
            sb.append("(timed out)");
        } else {
            sb.append("(exit code ").append(output.getExitCode()).append(") ");
            if (!output.getStderr().isEmpty()) {
                sb.append(output.getStderr());
            } else {
                sb.append(output.getStdout());
            }
        }
        return sb.toString();
    }

    @Nullable
    public static File getXcodeSelect() {
        return CidrToolsUtil.getXcodeSelect(new CidrToolEnvironment(), null);
    }

    @Nullable
    public static File getXcodeSelect(@NotNull CidrToolEnvironment environment, @Nullable ProgressIndicator indicator) {
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("xcode-select");
        cl.addParameter("-print-path");
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            ProcessOutput result = environment.getHostMachine().runProcess(cl, indicator, 1000);
            if (result.isTimeout()) {
                throw new ExecutionException("xcode-select timed out");
            }
            String err = result.getStderr().trim();
            if (!StringUtil.isEmpty((String)err)) {
                throw new ExecutionException(err);
            }
            String path = result.getStdout().trim();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                throw new ExecutionException("xcode-select returned an empty path");
            }
            return new File(path);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot determine default Xcode version: " + e.getMessage());
            return null;
        }
    }

    public static class Status {
        @NotNull
        public final StatusCode code;
        @NotNull
        @Nls
        public final String message;

        public Status(@NotNull StatusCode code, @NotNull @Nls String message) {
            this.code = code;
            this.message = message;
        }

        public static Status error(@NotNull @Nls String message) {
            return new Status(StatusCode.ERROR, message);
        }

        public static Status of(@NotNull Pair<Boolean, @Nls String> status) {
            return new Status((Boolean)status.first != false ? StatusCode.OK : StatusCode.ERROR, (String)status.second);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.code, this.message});
        }
    }

    public static enum StatusCode {
        OK,
        WARNING,
        ERROR;

    }
}

