/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RemoteHostUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.remote");
    public static final int DEFAULT_COMMAND_TIMEOUT = StringUtil.parseInt((String)System.getProperty("cidr.remote.command.timeout"), (int)5000);

    public static String remoteShell() {
        return AdvancedSettings.getString((String)"clion.remote.shell");
    }

    @NotNull
    public static String resolveSymlink(@NotNull HostMachine host, @NotNull String path) {
        try {
            RemoteHostUtil.assertRemoteUnixOnly(host);
            LOG.debug("Resolve symlink: " + path);
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"readlink", "-f", path});
            ProcessOutput output = host.runProcess(cmd, DEFAULT_COMMAND_TIMEOUT);
            if (CidrToolsUtil.checkSuccess(cmd, output, LOG)) {
                String stdout = output.getStdout().trim();
                if (output.getExitCode() == 0 && StringUtil.isNotEmpty((String)stdout)) {
                    return stdout;
                }
            }
        }
        catch (ExecutionException e) {
            LOG.debug("Error while resolving symlink: " + path, (Throwable)e);
        }
        return path;
    }

    @NotNull
    public static @NotNull String @NotNull [] resolveSymlink(@NotNull HostMachine host, @NotNull Collection<String> paths) {
        try {
            RemoteHostUtil.assertRemoteUnixOnly(host);
            LOG.debug("Resolve symlink: " + paths);
            if (paths.isEmpty()) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{RemoteHostUtil.remoteShell(), "-c"});
            cmd.addParameter(StringUtil.join(paths, p -> "readlink -f " + CommandLineUtil.posixQuote((String)p), (String)";"));
            ProcessOutput output = host.runProcess(cmd, DEFAULT_COMMAND_TIMEOUT);
            if (CidrToolsUtil.checkSuccess(cmd, output, LOG)) {
                String stdout = output.getStdout().trim();
                Object[] result = StringUtil.splitByLines((String)stdout);
                if (result.length == paths.size()) {
                    return result;
                }
                LOG.warn("paths are not resolved: " + paths + " -> " + Arrays.toString(result));
            }
        }
        catch (ExecutionException e) {
            LOG.debug("Error while resolving paths: " + paths, (Throwable)e);
        }
        return ArrayUtil.toStringArray(paths);
    }

    private static void assertRemoteUnixOnly(@NotNull HostMachine host) throws ExecutionException {
        if (!host.isRemote() || host.getOSType() == OSType.WIN) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(host.getName()));
        }
    }
}

