/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrRunConfigurationWithFrameworkInfo;
import com.jetbrains.cidr.statistics.CidrCollectorUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrTestingFrameworkProjectUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.testingFrameworks", 3);
    private static final EventId2<String, Integer> TEST_RUN_CONFIGURATION = GROUP.registerEvent("test.run.configuration", (EventField)CidrCollectorUtil.FRAMEWORK_ID_FIELD, (EventField)EventFields.Count);

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        Object2IntOpenHashMap data = new Object2IntOpenHashMap();
        List configurationsList = RunManager.getInstance((Project)project).getAllConfigurationsList();
        for (RunConfiguration runConfiguration : configurationsList) {
            ProgressManager.checkCanceled();
            String name = CidrTestingFrameworkProjectUsagesCollector.getFrameworkId(runConfiguration);
            if (name == null) continue;
            if (!data.containsKey((Object)name)) {
                data.put((Object)name, 0);
            }
            data.addTo((Object)name, 1);
        }
        return ContainerUtil.map2Set((Collection)data.keySet(), o -> TEST_RUN_CONFIGURATION.metric(o, (Object)data.getInt(o)));
    }

    @Nullable
    public static String getFrameworkId(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration instanceof CidrRunConfigurationWithFrameworkInfo) {
            return ((CidrRunConfigurationWithFrameworkInfo)runConfiguration).getFrameworkId();
        }
        return null;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }
}

