/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncludedHeadersRoot
extends HeadersRoot {
    private final boolean myRecursive;
    private final HeadersSearchPath.Kind myKind;
    private final boolean myPreferQuotes;

    @NotNull
    public static IncludedHeadersRoot create(@NotNull Project project, @NotNull VirtualFile includedDir, boolean recursive, boolean preferQuotes, @NotNull HeadersSearchPath.Kind kind) {
        return new Transient(project, includedDir, recursive, preferQuotes, kind);
    }

    @NotNull
    public static IncludedHeadersRoot create(@NotNull Project project, @NotNull VirtualFilePointer includedDir, boolean recursive, boolean preferQuotes, @NotNull HeadersSearchPath.Kind kind) {
        return new Pointer(project, includedDir, recursive, preferQuotes, kind);
    }

    private IncludedHeadersRoot(@NotNull Project project, boolean recursive, boolean preferQuotes, @NotNull HeadersSearchPath.Kind kind) {
        super(project);
        this.myRecursive = recursive;
        this.myKind = kind;
        this.myPreferQuotes = preferQuotes;
    }

    @Override
    @Nls
    @NotNull
    public String getPresentableName() {
        return CidrProjectModelBundle.message("header.search.root.included.headers", new Object[0]);
    }

    @NotNull
    public abstract String getUrl();

    public boolean isRecursive() {
        return this.myRecursive;
    }

    public boolean preferQuotes() {
        return this.myPreferQuotes;
    }

    @Override
    @NotNull
    public HeadersSearchPath.Kind getKind() {
        return this.myKind;
    }

    public abstract boolean isSynthetic();

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        return IncludedHeadersRoot.processUnder(processor, this.getVirtualFile(), this.myRecursive, this.myProject);
    }

    public String toString() {
        return this.getName() + " @ " + this.getUrl() + ": " + this.myKind.toString() + (this.myRecursive ? " [recursive]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IncludedHeadersRoot root = (IncludedHeadersRoot)((Object)o);
        return this.myRecursive == root.myRecursive && this.myKind == root.myKind;
    }

    public int hashCode() {
        VirtualFile file = this.getVirtualFile();
        int hash = this.myRecursive ? 1 : 0;
        hash = 31 * hash + this.myKind.hashCode();
        hash = 31 * hash + (file != null ? file.hashCode() : 0);
        return hash;
    }

    private static final class Transient
    extends IncludedHeadersRoot {
        @NotNull
        private final VirtualFile myFile;

        private Transient(@NotNull Project project, @NotNull VirtualFile dir, boolean recursive, boolean preferQuotes, @NotNull HeadersSearchPath.Kind kind) {
            super(project, recursive, preferQuotes, kind);
            this.myFile = dir;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myFile.getUrl();
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }

        @Override
        public boolean isValid() {
            return this.myFile.isValid();
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            Transient that = (Transient)((Object)o);
            return this.myFile.equals(that.myFile);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.myFile.hashCode();
        }
    }

    private static final class Pointer
    extends IncludedHeadersRoot {
        @NotNull
        private final VirtualFilePointer myPointer;

        private Pointer(@NotNull Project project, @NotNull VirtualFilePointer dir, boolean recursive, boolean preferQuotes, @NotNull HeadersSearchPath.Kind kind) {
            super(project, recursive, preferQuotes, kind);
            this.myPointer = dir;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myPointer.getFile();
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myPointer.getUrl();
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public boolean isValid() {
            return this.myPointer.isValid();
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            Pointer pointer = (Pointer)((Object)o);
            return this.myPointer.equals(pointer.myPointer);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.myPointer.hashCode();
        }
    }
}

