/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedFilesProcessor;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeadersSearchRoot
extends SyntheticFileSystemItem {
    protected HeadersSearchRoot(@NotNull Project project) {
        super(project);
    }

    public PsiFileSystemItem getParent() {
        return null;
    }

    @Nullable
    public abstract VirtualFile getVirtualFile();

    public abstract boolean isValid();

    @NotNull
    @NonNls
    public final String getName() {
        return this.getPresentableName();
    }

    @NotNull
    @Nls
    public abstract String getPresentableName();

    @NotNull
    public HeadersSearchPath.Kind getKind() {
        return HeadersSearchPath.Kind.SYSTEM;
    }

    public static boolean processUnder(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor, @Nullable VirtualFile base, boolean recursive, @NotNull Project project) {
        if (base == null) {
            return true;
        }
        if (IncludedFilesProcessor.shouldSkip(base, processor)) {
            return true;
        }
        if (processor instanceof HeadersSearchRootProcessor) {
            if (!IncludedFilesProcessor.processFile(project, base, processor)) {
                return false;
            }
            if (((HeadersSearchRootProcessor)processor).shouldProcessRootsOnly()) {
                return true;
            }
        }
        if (processor instanceof SpecificNameItemProcessor) {
            String name = ((SpecificNameItemProcessor)processor).getName();
            VirtualFile file = base.findChild(name);
            return file == null || IncludedFilesProcessor.processFile(project, file, processor);
        }
        if (!base.isValid()) {
            return true;
        }
        VirtualFile[] children = base.getChildren();
        return children == null || IncludedFilesProcessor.processFiles(project, Arrays.asList(children), recursive, processor);
    }

    protected boolean processCustomFileSet(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor, @NotNull Iterable<VirtualFile> files, boolean recursive) {
        return IncludedFilesProcessor.processFiles(this.myProject, files, recursive, processor);
    }
}

