/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class HeadersSearchPath {
    private static final int KIND = 7;
    private static final int RECURSIVE = 8;
    private static final int PREFER_QUOTES = 16;
    @NlsSafe
    @NotNull
    private final String myPath;
    private final int myFlags;

    public HeadersSearchPath(@NlsSafe @NotNull String path, int flags) {
        this.myPath = path;
        this.myFlags = flags;
    }

    public HeadersSearchPath(@NotNull File file, boolean recursive, @NotNull Kind kind) {
        this(file.getPath(), recursive, kind, false);
    }

    public HeadersSearchPath(@NlsSafe @NotNull String path, boolean recursive, @NotNull Kind kind) {
        this(path, recursive, kind, false);
    }

    public HeadersSearchPath(@NlsSafe @NotNull String path, boolean recursive, @NotNull Kind kind, boolean preferQuotes) {
        this(path, (recursive ? 8 : 0) | (preferQuotes ? 16 : 0) | kind.ordinal());
    }

    @NotNull
    public static HeadersSearchPath includes(@NlsSafe @NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.SYSTEM);
    }

    @NotNull
    public static HeadersSearchPath includes(@NotNull File file) {
        return HeadersSearchPath.includes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NlsSafe @NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.USER);
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NotNull File file) {
        return HeadersSearchPath.builtInIncludes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NlsSafe @NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.BUILTIN);
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NotNull File file) {
        return HeadersSearchPath.userIncludes(file.getPath());
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NlsSafe @NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.FRAMEWORK);
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NotNull File file) {
        return HeadersSearchPath.frameworks(file.getPath());
    }

    @NlsSafe
    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NlsSafe
    @NotNull
    public String getUrl() {
        return VfsUtilCore.pathToUrl((String)this.myPath);
    }

    public boolean isRecursive() {
        return (this.myFlags & 8) != 0;
    }

    @NotNull
    public Kind getKind() {
        return Kind.fromInt(this.myFlags & 7);
    }

    public boolean isBuiltInHeaders() {
        return this.getKind() == Kind.BUILTIN;
    }

    public boolean isFrameworksSearchPath() {
        return this.getKind() == Kind.FRAMEWORK || this.getKind() == Kind.USER_FRAMEWORK;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public boolean preferQuotes() {
        return (this.myFlags & 0x10) != 0;
    }

    public boolean isAncestorOf(@NotNull VirtualFile file, boolean checkRecursive) {
        return FileUtil.pathsEqual((String)this.getPath(), (String)file.getParent().getPath()) || (this.isRecursive() || !checkRecursive) && FileUtil.isAncestor((String)this.getPath(), (String)file.getPath(), (boolean)true);
    }

    @NotNull
    public HeadersSearchPath createNonRecursiveChildPath(@NlsSafe @NotNull String path) {
        if (!this.isRecursive()) {
            return this;
        }
        return new HeadersSearchPath(path, this.getFlags() ^ 8);
    }

    public String toString() {
        return "HeadersSearchPath{" + this.myPath + ", " + this.getKind().toString() + ", " + (this.isRecursive() ? "recursive" : "non-recursive") + (this.isFrameworksSearchPath() ? ", frameworks" : "") + (this.isBuiltInHeaders() ? ", builtin" : "") + (this.preferQuotes() ? ", prefer quotes" : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersSearchPath that = (HeadersSearchPath)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        return FileUtil.pathsEqual((String)this.myPath, (String)that.myPath);
    }

    public int hashCode() {
        int result = FileUtil.pathHashCode((String)this.myPath);
        result = 31 * result + this.myFlags;
        return result;
    }

    public static enum Kind {
        SYSTEM,
        USER,
        FRAMEWORK,
        USER_FRAMEWORK,
        BUILTIN;


        @NotNull
        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BUILTIN -> "builtin";
                case SYSTEM -> "system";
                case USER -> "user";
                case USER_FRAMEWORK -> "user_framework";
                case FRAMEWORK -> "framework";
            };
        }

        public boolean isSystem() {
            return this == BUILTIN || this == SYSTEM || this == FRAMEWORK;
        }

        public boolean isUser() {
            return this == USER || this == USER_FRAMEWORK;
        }

        public boolean isFramework() {
            return this == FRAMEWORK || this == USER_FRAMEWORK;
        }

        @NotNull
        public static Kind fromInt(int kindFlags) {
            return switch (kindFlags) {
                case 1 -> USER;
                case 2 -> FRAMEWORK;
                case 3 -> USER_FRAMEWORK;
                case 4 -> BUILTIN;
                default -> SYSTEM;
            };
        }
    }

    @FunctionalInterface
    public static interface FilePointerFactory {
        @NotNull
        public VirtualFilePointer create(@NlsSafe @NotNull String var1);
    }
}

