/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import icons.CidrProjectModelIcons;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppleFramework
extends HeadersRoot {
    @NotNull
    @NonNls
    public static final String HEADERS_DIR_NAME = "Headers";
    @NotNull
    @NonNls
    public static final String PRIVATE_HEADERS_DIR_NAME = "PrivateHeaders";
    @NotNull
    @NonNls
    public static final String MODULES_DIR_NAME = "Modules";
    @NotNull
    @NonNls
    public static final String FRAMEWORKS_DIR_NAME = "Frameworks";
    @NonNls
    public static final String[] HEADERS_DIR_NAMES = new String[]{"Headers", "PrivateHeaders"};
    @NotNull
    @NlsSafe
    private final String myName;

    protected AppleFramework(@NotNull Project project, @NotNull @NlsSafe String name) {
        super(project);
        this.myName = name;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getPresentableName() {
        return this.myName;
    }

    @Nullable
    public abstract PsiFileSystemItem getParentSdkOrFrameworkItem();

    public boolean isLibrary() {
        return false;
    }

    public abstract boolean containsHeader(@Nullable VirtualFile var1);

    public boolean process(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor, @NotNull Set<? super String> processed) {
        if (!processed.add(this.getName())) {
            return true;
        }
        if (processor instanceof HeadersSearchRootProcessor) {
            return this.processChildren(processor);
        }
        if (this.isValid()) {
            return AppleFramework.processFileSystemItem(processor, (PsiFileSystemItem)this);
        }
        return true;
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor instanceof HeadersSearchRootProcessor) {
            HeadersSearchRootProcessor.FrameworkResult result = ((HeadersSearchRootProcessor)processor).processFramework(this);
            switch (result) {
                case ABORT: {
                    return false;
                }
                case SKIP_CHILDREN: {
                    return true;
                }
            }
        }
        return this.processFrameworkChildren(processor);
    }

    protected abstract boolean processFrameworkChildren(PsiElementProcessor<? super PsiFileSystemItem> var1);

    public static boolean isFrameworkRoot(@NotNull VirtualFile file) {
        return file.isDirectory() && file.getName().endsWith(".framework");
    }

    public Icon getIcon(int flags) {
        return CidrProjectModelIcons.Framework;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppleFramework framework = (AppleFramework)((Object)o);
        return this.myName.equals(framework.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public abstract String toString();
}

