/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerCommandLineShortener;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.system.HostMachine;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/OCResponseFileShortener;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerCommandLineShortener;", "()V", "responseFileFormat", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches$Format;", "getResponseFileFormat", "()Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches$Format;", "createResponseFile", "Ljava/nio/file/Path;", "responseFileText", "", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "shorten", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "cl", "Companion", "intellij.cidr.projectModel"})
public abstract class OCResponseFileShortener
implements OCCompilerCommandLineShortener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Path> RESPONSE_FILE_KEY = Key.create((String)"OCResponseFileShortener.RESPONSE_FILE");

    @NotNull
    public abstract CidrCompilerSwitches.Format getResponseFileFormat();

    @Override
    @NotNull
    public GeneralCommandLine shorten(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool) {
        CidrCompilerSwitches switches = new CidrCompilerSwitches(cl.getParametersList().getList());
        String responseFileText = switches.getCommandLineString(this.getResponseFileFormat());
        Path responseFile = this.createResponseFile(responseFileText, environment, tempFilesPool);
        GeneralCommandLine shortenedCommandLine = new GeneralCommandLine();
        shortenedCommandLine.withExePath(cl.getExePath()).withWorkDirectory(cl.getWorkDirectory()).withEnvironment(cl.getEnvironment()).withParentEnvironmentType(cl.getParentEnvironmentType()).withCharset(cl.getCharset()).withInput(cl.getInputFile()).withRedirectErrorStream(cl.isRedirectErrorStream());
        shortenedCommandLine.addParameter("@" + environment.toEnvPath(((Object)responseFile.toAbsolutePath()).toString()));
        OCCompilerBase.LOG.debug("Running compiler " + cl + ".\nResponse file text: " + responseFileText);
        shortenedCommandLine.putUserData(RESPONSE_FILE_KEY, (Object)responseFile);
        return shortenedCommandLine;
    }

    private final Path createResponseFile(String responseFileText, CidrToolEnvironment environment, TempFilesPool tempFilesPool) throws ExecutionException {
        try {
            HostMachine host = environment.getHostMachine();
            Path tmpDir = host.getTempDirectory();
            return tempFilesPool.writeToTempFile(environment.getHostMachine(), responseFileText, tmpDir, "response-file", "");
        }
        catch (IOException e) {
            throw new ExecutionException(CidrProjectModelBundle.message("unable.to.create.temporary.file", new Object[0]), (Throwable)e);
        }
    }

    @JvmStatic
    public static final void deleteResponseFile(@Nullable UserDataHolder holder, @NotNull TempFilesPool tempFilesPool) {
        Companion.deleteResponseFile(holder, tempFilesPool);
    }

    @JvmStatic
    @Nullable
    public static final Path getResponseFile(@Nullable UserDataHolder holder) {
        return Companion.getResponseFile(holder);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/OCResponseFileShortener$Companion;", "", "()V", "RESPONSE_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "copyResponseFileData", "", "from", "Lcom/intellij/openapi/util/UserDataHolder;", "to", "deleteResponseFile", "holder", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "getResponseFile", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void deleteResponseFile(@Nullable UserDataHolder holder, @NotNull TempFilesPool tempFilesPool) {
            Path path;
            Object object = holder;
            if (object == null || (object = (path = (Path)object.getUserData(RESPONSE_FILE_KEY))) == null) {
                return;
            }
            Object responseFile = object;
            try {
                tempFilesPool.delete((Path)responseFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public final void copyResponseFileData(@NotNull UserDataHolder from, @NotNull UserDataHolder to) {
            Path path = (Path)from.getUserData(RESPONSE_FILE_KEY);
            if (path == null) {
                return;
            }
            Path responseFile = path;
            to.putUserData(RESPONSE_FILE_KEY, (Object)responseFile);
        }

        @JvmStatic
        @Nullable
        public final Path getResponseFile(@Nullable UserDataHolder holder) {
            UserDataHolder userDataHolder = holder;
            return userDataHolder != null ? (Path)userDataHolder.getUserData(RESPONSE_FILE_KEY) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

