/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCOutputParser;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u001e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0016J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u001e\u0010#\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u0004\u0018\u00010\u0014J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "project", "Lcom/intellij/openapi/project/Project;", "executable", "Ljava/io/File;", "workingDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "(Lcom/intellij/openapi/project/Project;Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "addExtraSwitches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "ccInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "originalSwitches", "cxxStandard", "", "cudaInstallPath", "adjustMSVCFlags", "", "switches", "collectInfo", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "extractExplicit", "filterDuplicateCCBin", "list", "filterOptions", "skipOptions", "", "fromCUDAArch", "getComputeCapability", "orig", "getHostCompiler", "parser", "Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCOutputParser;", "readVersion", "resolveAndSyncCudaHeaders", "runNVCC", "Companion", "intellij.cidr.projectModel"})
public final class NVCCCompiler
extends OCCompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final List<String> defaultCudaInstallPaths;
    @NotNull
    private static final Set<String> skipSwitches;

    public NVCCCompiler(@NotNull Project project, @NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool) {
        super(executable, workingDirectory, environment, tempFilesPool);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final String readVersion() {
        return this.doReadVersion(CollectionsKt.listOf((Object)"--version"), (Function<ProcessOutput, String>)((Function)NVCCCompiler::readVersion$lambda$1));
    }

    private final String extractExplicit(List<String> switches) {
        String string;
        Object v0;
        block3: {
            Iterable iterable = switches;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"arch=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"sm_", (boolean)false, (int)2, null))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        String string2 = v0;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            int idx = StringsKt.indexOf$default((CharSequence)it, (String)"sm_", (int)0, (boolean)false, (int)6, null);
            String string3 = it.substring(idx, idx + 5);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    private final String fromCUDAArch(List<String> switches) {
        String string;
        Object v0;
        block3: {
            Iterable iterable = switches;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-D__CUDA_ARCH__", (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        String string2 = v0;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String subStr = StringsKt.dropLast((String)StringsKt.substringAfter$default((String)it, (String)"=", null, (int)2, null), (int)1);
            string = "sm_" + subStr;
        } else {
            string = null;
        }
        return string;
    }

    private final String getComputeCapability(List<String> switches, CidrCompilerSwitches orig) {
        List switchList = CollectionsKt.plus((Collection)switches, (Iterable)orig.getList(CidrCompilerSwitches.Format.RAW));
        String string = this.extractExplicit(switchList);
        if (string == null && (string = this.fromCUDAArch(switchList)) == null) {
            string = "sm_20";
        }
        return "--cuda-gpu-arch=" + string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> adjustMSVCFlags(List<String> switches) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = switches;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? "-" + StringsKt.drop((String)it, (int)1) : it);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches originalSwitches) throws ExecutionException {
        return this.runNVCC(originalSwitches);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$takeWhile$iv = switches.getList(CidrCompilerSwitches.Format.RAW);
        boolean $i$f$takeWhile22 = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            String it = (String)item$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"&&"))) break;
            list$iv.add(item$iv);
        }
        List list = list$iv;
        CidrCompilerSwitches cleanSwitches = new CidrCompilerSwitches(list);
        Iterable $i$f$takeWhile22 = skipOptions;
        Set<String> set = skipSwitches;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set switchesToSkip = SetsKt.plus(set, (Iterable)((List)destination$iv$iv));
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>((Set<String>)switchesToSkip, skipOptions){
            private boolean skipOptionValue;
            final /* synthetic */ Set<String> $switchesToSkip;
            final /* synthetic */ Set<String> $skipOptions;
            {
                this.$switchesToSkip = $switchesToSkip;
                this.$skipOptions = $skipOptions;
            }

            public final boolean getSkipOptionValue() {
                return this.skipOptionValue;
            }

            public final void setSkipOptionValue(boolean bl) {
                this.skipOptionValue = bl;
            }

            @NotNull
            public Boolean apply(@NotNull String param, @Nullable String nextParam) {
                boolean bl;
                block8: {
                    boolean isSwitch = this.$switchesToSkip.contains(param);
                    boolean tokenIsSwitch = StringsKt.startsWith$default((String)param, (String)"-", (boolean)false, (int)2, null);
                    if (this.$skipOptions.contains(param)) {
                        this.skipOptionValue = tokenIsSwitch;
                        return false;
                    }
                    if (this.skipOptionValue) {
                        this.skipOptionValue = false;
                        if (!isSwitch) {
                            return false;
                        }
                    }
                    if (isSwitch) {
                        this.skipOptionValue = true;
                        return false;
                    }
                    Iterable $this$any$iv = this.$switchesToSkip;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)param, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return false;
                }
                return true;
            }
        };
        return cleanSwitches.filterOptions((BiFunction<? super String, ? super String, Boolean>)argumentsFilter2);
    }

    private final List<String> filterDuplicateCCBin(List<String> list) {
        int n;
        block8: {
            int n2;
            Iterable $this$count$iv = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!(StringsKt.startsWith$default((String)it, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"--compiler-bindir", (boolean)false, (int)2, null)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            if (n2 <= 1) {
                return list;
            }
            List<String> $this$indexOfLast$iv = list;
            boolean $i$f$indexOfLast = false;
            ListIterator<String> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"--compiler-bindir", (boolean)false, (int)2, null))) continue;
                n = iterator$iv.nextIndex();
                break block8;
            }
            n = -1;
        }
        int lastIndex = n;
        List result = new ArrayList();
        boolean lastWasCCBin = false;
        int n3 = list.size();
        for (int idx = 0; idx < n3; ++idx) {
            String elem = list.get(idx);
            if (StringsKt.startsWith$default((String)elem, (String)"-ccbin=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)elem, (String)"--compiler-bindir=", (boolean)false, (int)2, null)) {
                if (idx != lastIndex) continue;
                result.add(elem);
                continue;
            }
            if (StringsKt.startsWith$default((String)elem, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)elem, (String)"--compiler-bindir", (boolean)false, (int)2, null)) {
                lastWasCCBin = true;
                if (idx != lastIndex) continue;
                result.add(elem);
                continue;
            }
            if (lastWasCCBin && lastIndex != idx - 1) continue;
            result.add(elem);
        }
        return result;
    }

    private final String getHostCompiler(NVCCOutputParser parser) {
        String compiler = parser.getCompiler();
        Path path = parser.getFullCompilerPath(compiler);
        if (path == null) {
            return compiler;
        }
        Path fullCompiler = path;
        return PathKt.exists((Path)fullCompiler) && PathKt.isFile((Path)fullCompiler) ? ((Object)fullCompiler).toString() : compiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CompilerInfo runNVCC(CidrCompilerSwitches switches) throws ExecutionException {
        Path path;
        CompilerInfo compilerInfo;
        Path emptyFile = null;
        try {
            Collection collection;
            HostMachine host = this.myEnvironment.getHostMachine();
            Path tempDir = host.getTempDirectory();
            emptyFile = this.myTempFilesPool.writeToTempFile(host, "", tempDir, "compiler-file", ".cu");
            Pair<GeneralCommandLine, String> pair = NVCCCompiler.runNVCC$createCompilerExecutionCommandLine(this, switches, emptyFile);
            GeneralCommandLine commandLine1 = (GeneralCommandLine)pair.component1();
            String userFriendlyCommandLine1 = (String)pair.component2();
            OCCompilerBase.LOG.debug("Running: " + userFriendlyCommandLine1);
            ProcessOutput output = OCCompilerBase.outCompilerRunner.run(commandLine1, this.myEnvironment);
            OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine1);
            OCCompilerBase.LOG.debug("Got stderr:\n" + output.getStderr() + "\nstdout:\n" + output.getStdout());
            Collection collection2 = output.getStderrLines();
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = output.getStdoutLines();
            } else {
                collection = collection2;
            }
            List outputLines = (List)collection;
            NVCCOutputParser outputParser = new NVCCOutputParser(outputLines, this.myEnvironment);
            String compiler = this.getHostCompiler(outputParser);
            List<String> compilerFlags = outputParser.getFlags();
            OCCompilerKind compKind = OCCompilerResolver.Companion.resolve(this.project, host.getPath(compiler, new String[0]), this.myEnvironment);
            if (Intrinsics.areEqual((Object)compKind, (Object)NVCCCompilerKind.INSTANCE)) {
                throw new ExecutionException(CidrProjectModelBundle.message("nvcc.should.not.invoke.itself", new Object[0]));
            }
            OCCompiler comp = compKind.getCompilerInstance(this.project, new File(compiler), this.myWorkingDirectory, this.myEnvironment, this.myTempFilesPool);
            CidrCompilerSwitches resultSwitches = new CidrSwitchBuilder().addAllRaw(compilerFlags).build();
            CompilerInfo ccInfo = comp.collectInfo(CLanguageKind.CPP, resultSwitches);
            CidrCompilerSwitches hostCompilerFlags = this.addExtraSwitches(ccInfo, switches, outputParser.getCxxStandard(), outputParser.getCUDAInstallDir());
            Map features = MapsKt.toMutableMap(ccInfo.getFeatures());
            features.put(OCCompilerFeatures.HostCompilerKind.HOST_COMPILER_KIND, compKind);
            features.put(OCCompilerFeatures.HostCompilerFlags.HOST_COMPILER_FLAGS, hostCompilerFlags);
            compilerInfo = new CompilerInfo(switches, ccInfo.getDefines(), features, ccInfo.getHeadersSearchPaths(), ccInfo.getImplicitIncludes(), ccInfo.getPrecompiledIncludes(), ccInfo.getWarnings(), ccInfo.getCompilerExitCode());
            path = emptyFile;
        }
        catch (IOException e) {
            try {
                throw new ExecutionException((Throwable)e);
            }
            catch (Throwable throwable) {
                block8: {
                    Path path2 = emptyFile;
                    if (path2 == null) break block8;
                    Path it = path2;
                    boolean bl = false;
                    this.myTempFilesPool.delete(it);
                }
                throw throwable;
            }
        }
        if (path != null) {
            Path it = path;
            boolean bl = false;
            this.myTempFilesPool.delete(it);
        }
        return compilerInfo;
    }

    private final CidrCompilerSwitches addExtraSwitches(CompilerInfo ccInfo, CidrCompilerSwitches originalSwitches, String cxxStandard, String cudaInstallPath) {
        String cudaPath;
        boolean hasCXXFlag;
        List additionalArgs;
        List<String> switchesList;
        block4: {
            Object[] objectArray = new String[]{"-x", "-FI"};
            switchesList = this.filterOptions(ccInfo.getSwitches(), SetsKt.mutableSetOf((Object[])objectArray)).getList(CidrCompilerSwitches.Format.RAW);
            Object[] objectArray2 = new String[]{this.getComputeCapability(switchesList, originalSwitches)};
            additionalArgs = CollectionsKt.mutableListOf((Object[])objectArray2);
            Iterable $this$any$iv = switchesList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!(StringsKt.startsWith$default((String)it, (String)"-std=c++", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"/std:c++", (boolean)false, (int)2, null))) continue;
                    v0 = true;
                    break block4;
                }
                v0 = hasCXXFlag = false;
            }
        }
        if (((CharSequence)cxxStandard).length() > 0 && !hasCXXFlag) {
            ((Collection)additionalArgs).add(cxxStandard);
        }
        List cudaPathFlag = ((CharSequence)(cudaPath = this.resolveAndSyncCudaHeaders(cudaInstallPath))).length() > 0 ? CollectionsKt.listOf((Object)("--cuda-path=" + cudaPath)) : CollectionsKt.emptyList();
        List allFlags = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.adjustMSVCFlags(switchesList), (Iterable)additionalArgs), (Iterable)cudaPathFlag);
        return new CidrCompilerSwitches(allFlags);
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveAndSyncCudaHeaders(String cudaInstallPath) {
        String string;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String cudaInstall;
        String it;
        HostMachine hostMachine = this.myEnvironment.getHostMachine();
        if (((CharSequence)cudaInstallPath).length() > 0) {
            v0 = cudaInstallPath;
        } else if (hostMachine.getOSType() == OSType.LINUX) {
            Object v1;
            block10: {
                Iterable $this$firstOrNull$iv = defaultCudaInstallPaths;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (String)element$iv;
                    boolean bl = false;
                    if (!PathKt.exists((Path)hostMachine.getPath(it, new String[0]))) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            if ((v0 = (String)v1) == null) {
                v0 = "";
            }
        } else {
            OCCompilerBase.LOG.debug("Could not find cuda install path on " + hostMachine.getOSType().name());
            v0 = cudaInstall = "";
        }
        if (!hostMachine.isRemote() || NVCCCompilerKt.access$runsInsideWSL(hostMachine)) {
            return cudaInstall;
        }
        Path path = hostMachine.getPath(cudaInstall, new String[0]);
        Iterable iterable = PathsKt.listDirectoryEntries((Path)path, (String)"include");
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NVCCCompilerKt.access$toCanonicalPath(hostMachine, ((Object)it2.toAbsolutePath()).toString()));
        }
        List includeDirectory = (List)destination$iv$iv;
        List resolvedPaths = hostMachine.resolveAndCache(includeDirectory);
        if (resolvedPaths.isEmpty()) {
            string = "";
        } else {
            Path firstPath = Path.of((String)CollectionsKt.first((List)resolvedPaths), new String[0]);
            string = ((Object)firstPath.getParent().toAbsolutePath()).toString();
        }
        return string;
    }

    private static final String readVersion$lambda$1(ProcessOutput it) {
        MatchResult matchResult;
        Object object;
        Regex regex;
        Object object2 = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        Regex regex2 = regex = new Regex(".+V(.+?)$", SetsKt.mutableSetOf((Object[])object2));
        object2 = it.getStdout();
        if (object2.length() == 0) {
            Regex regex3 = regex;
            boolean bl = false;
            object = it.getStderr();
            regex = regex3;
        } else {
            object = object2;
        }
        return (matchResult = Regex.find$default((Regex)regex, (CharSequence)((CharSequence)object), (int)0, (int)2, null)) != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
    }

    private static final Pair<GeneralCommandLine, String> runNVCC$createCompilerExecutionCommandLine(NVCCCompiler this$0, CidrCompilerSwitches $switches, Path parameter) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        GeneralCommandLine cl = new GeneralCommandLine();
        this$0.myEnvironment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        List<String> switchesList = this$0.filterDuplicateCCBin($switches.getList(CidrCompilerSwitches.Format.RAW));
        String[] stringArray = (String[])switchesList;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"-isystem", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"-isystem=", (boolean)false, (int)2, null)) {
                String string3 = it.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                string = "-isystem=" + string3;
            } else {
                string = it;
            }
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"'", (String)"\"", (boolean)false, (int)4, null));
        }
        List extraFlags = (List)destination$iv$iv;
        cl.setExePath(this$0.getExecutable().getPath());
        cl.withWorkDirectory(this$0.myWorkingDirectory);
        Collection $this$toTypedArray$iv = extraFlags;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        cl.addParameters(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"--dryrun"};
        cl.addParameters(stringArray);
        stringArray = new String[]{this$0.myEnvironment.toEnvPath(((Object)parameter.toAbsolutePath()).toString())};
        cl.addParameters(stringArray);
        return new Pair((Object)cl, (Object)cl.getCommandLineString());
    }

    static {
        Object[] objectArray = new String[]{"/usr/lib/cuda", "/usr/local/cuda"};
        defaultCudaInstallPaths = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"-o", "--output", "--output=", "--output-file", "--output-file=", "-M", "-MM", "-MF", "-MG", "-MP", "-MT", "-MQ", "-MD", "-MMD", "--generate-dependencies", "--generate-nonsystem-dependencies", "--dependency-output", "--generate-dependency-targets", "--generate-dependencies-with-compile", "--generate-nonsystem-dependencies-with-compile"};
        skipSwitches = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u0004\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler$Companion;", "", "()V", "defaultCudaInstallPaths", "", "", "skipSwitches", "", "getCCBinOption", "combinedCompilerFlags", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getCCBinOption(@NotNull List<String> combinedCompilerFlags) {
            String cudaCCBinOption = null;
            int n = combinedCompilerFlags.size();
            for (int idx = 0; idx < n; ++idx) {
                String currentFlag = combinedCompilerFlags.get(idx);
                if (!StringsKt.startsWith$default((String)currentFlag, (String)"-ccbin", (boolean)false, (int)2, null)) {
                    if (!StringsKt.startsWith$default((String)currentFlag, (String)"--compiler-bindir", (boolean)false, (int)2, null)) continue;
                }
                cudaCCBinOption = StringsKt.contains$default((CharSequence)currentFlag, (CharSequence)"=", (boolean)false, (int)2, null) ? currentFlag : (idx + 1 < combinedCompilerFlags.size() ? "-ccbin=" + combinedCompilerFlags.get(idx + 1) : null);
                break;
            }
            return cudaCCBinOption;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

