/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageMacroFeature;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.PrecompiledInclude;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 12\u00020\u0001:\u0003123B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0003J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016JV\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010\"\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$H\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0002J\r\u0010*\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b+JL\u0010,\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020(2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a8\u00064"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "executable", "Ljava/io/File;", "workingDir", "env", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "buildMacrosFileTest", "", "defines", "", "collectHeaderPathsAndDefinesListFromCommandLine", "Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "args", "collectInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "output", "headersSearchPaths", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "includedHeaders", "includesMapping", "Lcom/jetbrains/cidr/lang/workspace/compiler/PrecompiledInclude;", "warnLog", "extractMSToolset", "Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$MSVCToolset;", "version", "", "filterOptions", "skipOptions", "", "getForceIncludeHeaders", "getIncludeMapping", "isSwitch", "", "parameter", "readVersion", "Lcom/intellij/openapi/util/NlsSafe;", "runCompiler", "originalSwitches", "requestSwitches", "environment", "runWithSkippedOptions", "Companion", "HeaderSearchPathsAndDefines", "MSVCToolset", "intellij.cidr.projectModel"})
public final class MSVCCompiler
extends OCCompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MSVCCompiler(@NotNull File executable, @NotNull File workingDir, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        super(executable, workingDir, env, tempFilesPool);
    }

    @Nullable
    public final String readVersion() {
        return this.doReadVersion(CollectionsKt.emptyList(), (Function<ProcessOutput, String>)((Function)MSVCCompiler::readVersion$lambda$0));
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        CidrCompilerSwitches requestSwitches = new MSVCSwitchBuilder(null, false, 3, null).withLanguageKind(languageKind).withSwitches(switches).withSwitch("/Be").withSwitch("/Bd").withSwitch("/EP").build();
        return this.runCompiler(languageKind, switches, requestSwitches, this.myEnvironment, false, new LinkedHashSet(), new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final CompilerInfo runCompiler(OCLanguageKind languageKind, CidrCompilerSwitches originalSwitches, CidrCompilerSwitches requestSwitches, CidrToolEnvironment environment, boolean runWithSkippedOptions, Set<String> skipOptions, List<String> warnLog) throws ExecutionException {
        Path it;
        Path path;
        CompilerInfo compilerInfo;
        Ref.ObjectRef responseFile = new Ref.ObjectRef();
        Path emptyFile = null;
        Path macroFile = null;
        try {
            CidrCompilerSwitches requestSwitches2 = this.filterOptions(requestSwitches, skipOptions);
            HostMachine host = environment.getHostMachine();
            Path tempDir = host.getTempDirectory();
            emptyFile = this.myTempFilesPool.writeToTempFile(host, "", tempDir, "compiler-file", "");
            Pair<GeneralCommandLine, String> pair = MSVCCompiler.runCompiler$createCompilerExecutionCommandLine(environment, this, requestSwitches2, (Ref.ObjectRef<Path>)responseFile, emptyFile);
            GeneralCommandLine commandLine1 = (GeneralCommandLine)pair.component1();
            String userFriendlyCommandLine1 = (String)pair.component2();
            OCCompilerBase.LOG.debug("Running 1st pass compiler: " + userFriendlyCommandLine1);
            ProcessOutput output = OCCompilerBase.outCompilerRunner.run(commandLine1, environment);
            if (output.isTimeout()) {
                throw OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine1);
            }
            if (output.getExitCode() != 0) {
                if (runWithSkippedOptions) throw OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine1);
                if (!MSVCCompilerKt.collectMSVCSkipOptions(output.getStderrLines(), skipOptions, warnLog)) throw OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine1);
                if (OCCompilerBase.LOG.isDebugEnabled()) {
                    OCCompilerBase.LOG.debug("Re-running compiler with skipped options: " + CollectionsKt.joinToString$default((Iterable)skipOptions, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
            } else {
                OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine1);
                if (OCCompilerBase.LOG.isDebugEnabled()) {
                    OCCompilerBase.LOG.debug("Compiler 1st output: \n" + output.getStderr());
                }
                List<String> cmdArgs = Companion.parseArguments(output.getStderrLines());
                HeaderSearchPathsAndDefines headerSearchPathsAndDefines = this.collectHeaderPathsAndDefinesListFromCommandLine(cmdArgs);
                List<HeadersSearchPath> headersSearchPaths = headerSearchPathsAndDefines.component1();
                List<String> definesList = headerSearchPathsAndDefines.component2();
                macroFile = this.myTempFilesPool.writeToTempFile(host, this.buildMacrosFileTest(definesList), tempDir, "compiler-file", "");
                Pair<GeneralCommandLine, String> pair2 = MSVCCompiler.runCompiler$createCompilerExecutionCommandLine(environment, this, requestSwitches2, (Ref.ObjectRef<Path>)responseFile, macroFile);
                GeneralCommandLine commandLine2 = (GeneralCommandLine)pair2.component1();
                String userFriendlyCommandLine2 = (String)pair2.component2();
                OCCompilerBase.LOG.debug("Running 2st pass compiler");
                output = OCCompilerBase.outCompilerRunner.run(commandLine2, environment);
                OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine2);
                List<File> includedHeaders = this.getForceIncludeHeaders(cmdArgs);
                List<PrecompiledInclude> includeMapping = this.getIncludeMapping(cmdArgs);
                OCCompilerBase.addEmulatedWarning(warnLog);
                CompilerInfo compilerInfo2 = this.collectInfo(languageKind, originalSwitches, output.getStdout(), headersSearchPaths, includedHeaders, includeMapping, warnLog);
                return compilerInfo2;
            }
            compilerInfo = this.runCompiler(languageKind, originalSwitches, requestSwitches2, environment, runWithSkippedOptions, skipOptions, warnLog);
            path = (Path)responseFile.element;
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (path != null) {
            it = path;
            boolean bl = false;
            this.myTempFilesPool.delete(it);
        }
        Path path2 = emptyFile;
        if (path2 == null) return compilerInfo;
        it = path2;
        boolean bl = false;
        this.myTempFilesPool.delete(it);
        return compilerInfo;
        finally {
            Path it2;
            Path path3 = (Path)responseFile.element;
            if (path3 != null) {
                it2 = path3;
                boolean bl2 = false;
                this.myTempFilesPool.delete(it2);
            }
            Path path4 = emptyFile;
            if (path4 != null) {
                it2 = path4;
                $i$a$-let-MSVCCompiler$runCompiler$2 = false;
                this.myTempFilesPool.delete(it2);
            }
            Path path5 = macroFile;
            if (path5 != null) {
                it2 = path5;
                boolean bl3 = false;
                this.myTempFilesPool.delete(it2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Object[] $this$filter$iv = (Object[])skipOptions;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.isSwitch(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = new String[]{"/Fa", "/Fd", "/Fe", "/Fi", "/Fm", "/Fo", "/Fr", "/FR", "/doc"};
        List skipSwitches = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object[])$this$filter$iv));
        Iterable $this$filter$iv2 = skipOptions;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.isSwitch(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List skipValues = (List)destination$iv$iv2;
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(this, (List<String>)skipValues, (List<String>)skipSwitches){
            private boolean skipOptionValue;
            final /* synthetic */ MSVCCompiler this$0;
            final /* synthetic */ List<String> $skipValues;
            final /* synthetic */ List<String> $skipSwitches;
            {
                this.this$0 = $receiver;
                this.$skipValues = $skipValues;
                this.$skipSwitches = $skipSwitches;
            }

            public final boolean getSkipOptionValue() {
                return this.skipOptionValue;
            }

            public final void setSkipOptionValue(boolean bl) {
                this.skipOptionValue = bl;
            }

            @NotNull
            public Boolean apply(@NotNull String parameter, @Nullable String nextParameter) {
                boolean tokenIsSwitch = MSVCCompiler.access$isSwitch(this.this$0, parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (this.$skipValues.contains(parameter)) {
                    return false;
                }
                if (this.$skipSwitches.contains(parameter)) {
                    this.skipOptionValue = true;
                    return false;
                }
                Iterable $this$forEach$iv = this.$skipSwitches;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)parameter, (String)it, (boolean)false, (int)2, null)) continue;
                    return false;
                }
                if (Intrinsics.areEqual((Object)parameter, (Object)"/FI") && CollectionsKt.contains((Iterable)this.$skipValues, (Object)nextParameter)) {
                    return false;
                }
                if (StringsKt.startsWith$default((String)parameter, (String)"/FI", (boolean)false, (int)2, null)) {
                    String string = parameter.substring(3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    if (this.$skipValues.contains(string)) {
                        return false;
                    }
                }
                return true;
            }
        };
        return switches.filterOptions((BiFunction<? super String, ? super String, Boolean>)argumentsFilter2);
    }

    private final boolean isSwitch(String parameter) {
        return StringsKt.startsWith$default((String)parameter, (String)"/", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNls
    private final String buildMacrosFileTest(List<String> defines) {
        void $this$filterTo$iv$iv;
        StringBuilder builder = new StringBuilder();
        builder.append("#ifdef __cplusplus\n# ifdef __has_include\n#  if __has_include(<version>)\n#   include <version>\n#  endif\n# endif\n#endif");
        builder.append('\n');
        builder.append("__cidr_defines_start__\n");
        Iterable $this$filter$iv = new LinkedHashSet(CollectionsKt.plus((Collection)MSVCCompilerKt.getBuiltinMacrosNames(), (Iterable)defines));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.append("#if (defined " + it + ")\n__cidr_define_" + it + " " + it + "\n#endif\n");
        }
        builder.append("__cidr_defines_end__\n");
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HeaderSearchPathsAndDefines collectHeaderPathsAndDefinesListFromCommandLine(@NotNull List<String> args2) {
        void $this$filterTo$iv$iv;
        Object define;
        ArrayList<Object> defines = new ArrayList<Object>();
        ArrayList<HeadersSearchPath> headerPaths = new ArrayList<HeadersSearchPath>();
        boolean nextIsIncludePath = false;
        boolean nextIsBuiltInIncludePath = false;
        for (String each : args2) {
            Object file;
            if (nextIsIncludePath || nextIsBuiltInIncludePath) {
                String path = FileUtil.resolveShortWindowsName((String)FileUtil.toCanonicalPath((String)each));
                file = FileUtil.isAbsolute((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
                headerPaths.add(new HeadersSearchPath((File)file, false, nextIsBuiltInIncludePath ? HeadersSearchPath.Kind.BUILTIN : HeadersSearchPath.Kind.SYSTEM));
                nextIsIncludePath = false;
                nextIsBuiltInIncludePath = false;
                continue;
            }
            nextIsIncludePath = Intrinsics.areEqual((Object)each, (Object)"-I");
            nextIsBuiltInIncludePath = Intrinsics.areEqual((Object)each, (Object)"-external:I");
            if (!StringsKt.startsWith$default((String)each, (String)"-D", (boolean)false, (int)2, null)) continue;
            file = new char[3];
            file[0] = 61;
            file[1] = 40;
            file[2] = 32;
            int eq = StringsKt.indexOfAny$default((CharSequence)each, (char[])file, (int)0, (boolean)false, (int)6, null);
            String string = each.substring(2, eq > -1 ? eq : each.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            define = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)define)))) continue;
            defines.add(define);
        }
        Iterable $this$filter$iv = defines;
        boolean $i$f$filter = false;
        define = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                CharSequence $this$all$iv = it;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(i);
                    boolean bl3 = false;
                    if (Character.isJavaIdentifierPart(c)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredDefines = (List)destination$iv$iv;
        return new HeaderSearchPathsAndDefines((List<HeadersSearchPath>)headerPaths, filteredDefines);
    }

    private final MSVCToolset extractMSToolset(int version) {
        boolean bl = 1500 <= version ? version < 1600 : false;
        if (bl) {
            return MSVCToolset.V90;
        }
        boolean bl2 = 1600 <= version ? version < 1700 : false;
        if (bl2) {
            return MSVCToolset.V100;
        }
        boolean bl3 = 1700 <= version ? version < 1800 : false;
        if (bl3) {
            return MSVCToolset.V110;
        }
        boolean bl4 = 1800 <= version ? version < 1900 : false;
        if (bl4) {
            return MSVCToolset.V120;
        }
        boolean bl5 = 1900 <= version ? version < 1910 : false;
        if (bl5) {
            return MSVCToolset.V140;
        }
        boolean bl6 = 1910 <= version ? version < 1920 : false;
        if (bl6) {
            return MSVCToolset.V141;
        }
        if (version >= 1920) {
            return MSVCToolset.V142;
        }
        return MSVCToolset.V142;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches, @NotNull String output, @NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<? extends File> includedHeaders, @NotNull List<PrecompiledInclude> includesMapping, @NotNull List<String> warnLog) {
        MSVCToolset toolset;
        LinkedHashMap features;
        List definesList;
        block18: {
            Object object;
            OCCompilerFeatures.Type<OCLanguageStandard> type;
            Object index$iv22;
            block20: {
                block19: {
                    block15: {
                        Object object2;
                        OCCompilerFeatures.Type<OCLanguageStandard> type2;
                        block17: {
                            block16: {
                                String defines = null;
                                defines = "";
                                int definesStart = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_start__\n", (int)0, (boolean)false, (int)6, null);
                                int definesEnd = StringsKt.indexOf$default((CharSequence)output, (String)"__cidr_defines_end__\n", (int)0, (boolean)false, (int)6, null);
                                if (definesStart > -1 && definesEnd > -1) {
                                    String string = output.substring(definesStart + 23, definesEnd);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    defines = string;
                                    StringBuilder builder = new StringBuilder();
                                    boolean hasNewLine = false;
                                    CharSequence $this$forEachIndexed$iv = defines;
                                    boolean $i$f$forEachIndexed22 = false;
                                    int index$iv22 = 0;
                                    for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
                                        void c;
                                        char item$iv = $this$forEachIndexed$iv.charAt(i);
                                        int n = index$iv22++;
                                        char c2 = item$iv;
                                        int i2 = n;
                                        boolean bl = false;
                                        if (c == 10) {
                                            if (hasNewLine) continue;
                                            if (i2 == 0 || defines.charAt(i2 - 1) != '\\') {
                                                hasNewLine = true;
                                            }
                                        } else {
                                            hasNewLine = false;
                                        }
                                        builder.append((char)c);
                                    }
                                    defines = builder.toString();
                                    $this$forEachIndexed$iv = defines;
                                    Regex $i$f$forEachIndexed22 = new Regex("^__cidr_define_", RegexOption.MULTILINE);
                                    index$iv22 = "#define ";
                                    defines = $i$f$forEachIndexed22.replace($this$forEachIndexed$iv, (String)index$iv22);
                                }
                                String[] hasNewLine = new String[]{"\n"};
                                definesList = StringsKt.split$default((CharSequence)defines, (String[])hasNewLine, (boolean)false, (int)0, (int)6, null);
                                features = new LinkedHashMap();
                                int version = Companion.getMSCVersion(definesList);
                                toolset = this.extractMSToolset(version);
                                if (!languageKind.isCpp()) break block15;
                                index$iv22 = features;
                                type2 = OCCompilerFeatures.LANGUAGE_STANDARD;
                                object2 = Companion.getMSVCCppLangVersion(definesList);
                                if (object2 == null) break block16;
                                String it = object2;
                                boolean bl = false;
                                OCLanguageStandard oCLanguageStandard = OCLanguageStandard.getCppStandard(it);
                                object2 = oCLanguageStandard;
                                if (oCLanguageStandard != null) break block17;
                            }
                            object2 = OCLanguageStandard.CPP11;
                        }
                        Object object3 = object2;
                        index$iv22.put(type2, object3);
                        ((Map)features).put(OCCompilerFeatures.Feature.CXX_MS_HAS_MAKE_INTEGER_SEQ, toolset.compareTo((Enum)MSVCToolset.V140) >= 0);
                        ((Map)features).put(OCCompilerFeatures.Feature.CXX_MS_PREFER_COPY_CTOR_OVER_USER_DEFINED, toolset.compareTo((Enum)MSVCToolset.V120) <= 0);
                        ((Map)features).put(OCCompilerFeatures.Feature.CXX_TYPE_INFO_IN_GLOBAL_NAMESPACE, true);
                        break block18;
                    }
                    ((Map)features).put(OCCompilerFeatures.Feature.C_VARIABLE_DECLARATION_RULES_ARE_C89_COMPATIBLE, toolset.compareTo((Enum)MSVCToolset.V110) <= 0);
                    index$iv22 = features;
                    type = OCCompilerFeatures.LANGUAGE_STANDARD;
                    object = Companion.getMsvcCLangVersion(definesList);
                    if (object == null) break block19;
                    String it = object;
                    boolean bl = false;
                    OCLanguageStandard oCLanguageStandard = OCLanguageStandard.getCStandard(it);
                    object = oCLanguageStandard;
                    if (oCLanguageStandard != null) break block20;
                }
                object = OCLanguageStandard.C11;
            }
            Object object4 = object;
            index$iv22.put(type, object4);
        }
        if (toolset.compareTo((Enum)MSVCToolset.V120) <= 0) {
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_MS_PREFER_COPY_CTOR_OVER_USER_DEFINED, true);
        }
        if (toolset.compareTo((Enum)MSVCToolset.V110) < 0) {
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, false);
            ((Map)features).put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, false);
        }
        ((Map)features).put(OCCompilerFeatures.Feature.IS_BASE_OF, true);
        boolean is64 = Companion.is64Bit(definesList);
        ((Map)features).put(OCCompilerFeatures.TypeSize.WCHAR_T, (short)2);
        ((Map)features).put(OCCompilerFeatures.TypeSize.INT, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG_LONG, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.FLOAT, (short)4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.DOUBLE, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, (short)8);
        ((Map)features).put(OCCompilerFeatures.TypeSize.SIZE_T, is64 ? (short)8 : 4);
        ((Map)features).put(OCCompilerFeatures.TypeSize.POINTER, is64 ? (short)8 : 4);
        return new CompilerInfo(switches, definesList, features, headersSearchPaths, includedHeaders, includesMapping, warnLog, 0, 128, null);
    }

    private final List<File> getForceIncludeHeaders(List<String> args2) {
        String forceIncludeCmd = "-FI";
        LinkedHashSet<File> result = new LinkedHashSet<File>(1);
        for (int i = 0; i < args2.size(); ++i) {
            String arg = args2.get(i);
            if (!StringsKt.startsWith$default((String)arg, (String)forceIncludeCmd, (boolean)false, (int)2, null) || ++i >= args2.size()) continue;
            String path = args2.get(i);
            File file = FileUtil.isWindowsAbsolutePath((String)path) ? new File(path) : new File(this.myWorkingDirectory, path);
            result.add(file);
        }
        return (List)new SmartList((Collection)result);
    }

    @NotNull
    public final List<PrecompiledInclude> getIncludeMapping(@NotNull List<String> args2) {
        String pchCreationCmd = "-Yc";
        String pchUsingCmd = "-Yu";
        String pchPathCmd = "-Fp";
        String precompileUntilHeaderName = null;
        String usePrecompiledHeadersUntilHeaderName = null;
        String customPchFilePath = null;
        int i = 0;
        while (i < args2.size()) {
            String arg = args2.get(i);
            if (++i == args2.size()) break;
            String nextArg = args2.get(i);
            boolean nextArgIsSwith = StringsKt.startsWith$default((CharSequence)nextArg, (char)'-', (boolean)false, (int)2, null);
            if (nextArgIsSwith) continue;
            String string = arg;
            if (Intrinsics.areEqual((Object)string, (Object)pchPathCmd)) {
                customPchFilePath = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchCreationCmd)) {
                precompileUntilHeaderName = nextArg;
            } else if (Intrinsics.areEqual((Object)string, (Object)pchUsingCmd)) {
                usePrecompiledHeadersUntilHeaderName = nextArg;
            }
            ++i;
        }
        SmartList result = new SmartList();
        if (customPchFilePath != null) {
            File pchFile = FileUtil.isAbsolute(customPchFilePath) ? new File(customPchFilePath) : new File(this.myWorkingDirectory, customPchFilePath);
            String canonicalPCHPath = FileUtil.toCanonicalPath((String)pchFile.getPath());
            if (precompileUntilHeaderName != null) {
                result.add((Object)new PrecompiledInclude(canonicalPCHPath, precompileUntilHeaderName, true));
            }
            if (usePrecompiledHeadersUntilHeaderName != null) {
                result.add((Object)new PrecompiledInclude(canonicalPCHPath, usePrecompiledHeadersUntilHeaderName, false));
            }
        }
        return (List)result;
    }

    private static final String readVersion$lambda$0(ProcessOutput output) {
        Object[] objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        MatchResult matchResult = Regex.find$default((Regex)new Regex(".+Version (.+?)$", SetsKt.mutableSetOf((Object[])objectArray)), (CharSequence)output.getStderr(), (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
    }

    private static final Pair<GeneralCommandLine, String> runCompiler$createCompilerExecutionCommandLine(CidrToolEnvironment $environment, MSVCCompiler this$0, CidrCompilerSwitches requestSwitches, Ref.ObjectRef<Path> responseFile, Path parameter) {
        GeneralCommandLine cl = new GeneralCommandLine();
        $environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        cl.setExePath(this$0.myExecutable.getPath());
        cl.withWorkDirectory(this$0.myWorkingDirectory);
        cl.addParameters(requestSwitches.getList(CidrCompilerSwitches.Format.RAW));
        cl = new MSVCResponseFileShortener().shorten(cl, $environment, this$0.myTempFilesPool);
        responseFile.element = OCResponseFileShortener.Companion.getResponseFile((UserDataHolder)cl);
        String[] stringArray = new String[]{$environment.toEnvPath(((Object)parameter.toAbsolutePath()).toString())};
        cl.addParameters(stringArray);
        Path path = (Path)responseFile.element;
        String userFriendlyCommandLine = cl.getCommandLineString() + " | @" + (path != null ? path.getFileName() : null) + "=" + requestSwitches.getCommandLineString(CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE);
        return new Pair((Object)cl, (Object)userFriendlyCommandLine);
    }

    @JvmStatic
    public static final int getMSCVersion(@NotNull List<String> defines) {
        return Companion.getMSCVersion(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMSVCCppLangVersion(@NotNull List<String> defines) {
        return Companion.getMSVCCppLangVersion(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMsvcCLangVersion(@NotNull List<String> defines) {
        return Companion.getMsvcCLangVersion(defines);
    }

    @JvmStatic
    public static final boolean is64Bit(@NotNull List<String> defines) {
        return Companion.is64Bit(defines);
    }

    @JvmStatic
    @Nullable
    public static final String getMacroFeatureSupport(@NotNull List<String> defines, @NotNull OCLanguageMacroFeature feature) {
        return Companion.getMacroFeatureSupport(defines, feature);
    }

    @JvmStatic
    @NotNull
    public static final List<String> parseArguments(@NotNull List<String> lines) {
        return Companion.parseArguments(lines);
    }

    @JvmStatic
    private static final List<String> splitArguments(String line) {
        return MSVCCompiler.Companion.splitArguments(line);
    }

    @JvmStatic
    @Nullable
    public static final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        return Companion.resolveLanguage(switches);
    }

    public static final /* synthetic */ boolean access$isSwitch(MSVCCompiler $this, String parameter) {
        return $this.isSwitch(parameter);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$MSVCToolset;", "", "(Ljava/lang/String;I)V", "V90", "V100", "V110", "V120", "V140", "V141", "V142", "intellij.cidr.projectModel"})
    public static final class MSVCToolset
    extends Enum<MSVCToolset> {
        public static final /* enum */ MSVCToolset V90 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V100 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V110 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V120 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V140 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V141 = new MSVCToolset();
        public static final /* enum */ MSVCToolset V142 = new MSVCToolset();
        private static final /* synthetic */ MSVCToolset[] $VALUES;

        public static MSVCToolset[] values() {
            return (MSVCToolset[])$VALUES.clone();
        }

        public static MSVCToolset valueOf(String value) {
            return Enum.valueOf(MSVCToolset.class, value);
        }

        static {
            $VALUES = mSVCToolsetArray = new MSVCToolset[]{MSVCToolset.V90, MSVCToolset.V100, MSVCToolset.V110, MSVCToolset.V120, MSVCToolset.V140, MSVCToolset.V141, MSVCToolset.V142};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007J \u0010\u000b\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0017\u001a\u00020\u0004H\u0003\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$Companion;", "", "()V", "getLanguageVersion", "", "defines", "", "languageDefine", "getMSCVersion", "", "getMSVCCppLangVersion", "getMacroFeatureSupport", "feature", "Lcom/jetbrains/cidr/lang/OCLanguageMacroFeature;", "getMsvcCLangVersion", "is64Bit", "", "parseArguments", "lines", "resolveLanguage", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "splitArguments", "line", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final int getMSCVersion(@NotNull List<String> defines) {
            Regex regex = new Regex("#define\\s+_MSC_VER\\s+(\\d+)");
            MatchResult matchResult = (MatchResult)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)defines), (Function1)((Function1)new Function1<String, MatchResult>(regex){
                final /* synthetic */ Regex $regex;
                {
                    this.$regex = $regex;
                    super(1);
                }

                @Nullable
                public final MatchResult invoke(@NotNull String it) {
                    return Regex.find$default((Regex)this.$regex, (CharSequence)it, (int)0, (int)2, null);
                }
            })));
            Object object = matchResult;
            if (matchResult == null) return 0;
            MatchResult it = object;
            boolean bl = false;
            Integer n = Integer.valueOf((String)it.getGroupValues().get(1));
            object = n;
            if (n == null) return 0;
            int n2 = (Integer)object;
            return n2;
        }

        @JvmStatic
        @Nullable
        public final String getMSVCCppLangVersion(@NotNull List<String> defines) {
            return this.getLanguageVersion(defines, "_MSVC_LANG");
        }

        @JvmStatic
        @Nullable
        public final String getMsvcCLangVersion(@NotNull List<String> defines) {
            return this.getLanguageVersion(defines, "__STDC_VERSION__");
        }

        private final String getLanguageVersion(List<String> defines, String languageDefine) {
            String string;
            Regex regex = new Regex("#define\\s+" + languageDefine + "\\s+(\\d+L?)");
            MatchResult matchResult = (MatchResult)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)defines), (Function1)((Function1)new Function1<String, MatchResult>(regex){
                final /* synthetic */ Regex $regex;
                {
                    this.$regex = $regex;
                    super(1);
                }

                @Nullable
                public final MatchResult invoke(@NotNull String it) {
                    return Regex.find$default((Regex)this.$regex, (CharSequence)it, (int)0, (int)2, null);
                }
            })));
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl = false;
                string = (String)it.getGroupValues().get(1);
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        public final boolean is64Bit(@NotNull List<String> defines) {
            boolean bl;
            block3: {
                Regex regex = new Regex("#define\\s+_WIN64\\s+1");
                Iterable $this$any$iv = defines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null) != null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @JvmStatic
        @Nullable
        public final String getMacroFeatureSupport(@NotNull List<String> defines, @NotNull OCLanguageMacroFeature feature) {
            String string;
            Regex regex = new Regex("#define\\s+" + feature.getMacro() + "\\s+(\\d+L?)");
            MatchResult matchResult = (MatchResult)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)defines), (Function1)((Function1)new Function1<String, MatchResult>(regex){
                final /* synthetic */ Regex $regex;
                {
                    this.$regex = $regex;
                    super(1);
                }

                @Nullable
                public final MatchResult invoke(@NotNull String it) {
                    return Regex.find$default((Regex)this.$regex, (CharSequence)it, (int)0, (int)2, null);
                }
            })));
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl = false;
                string = (String)it.getGroupValues().get(1);
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final List<String> parseArguments(@NotNull List<String> lines) {
            Object v3;
            List args2;
            block6: {
                Object v0;
                Object it;
                Object object2;
                block5: {
                    Iterable iterable = lines;
                    for (Object object2 : iterable) {
                        it = (String)object2;
                        boolean bl = false;
                        if (!(StringsKt.startsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"'", (boolean)false, (int)2, null))) continue;
                        v0 = object2;
                        break block5;
                    }
                    v0 = null;
                }
                String string = v0;
                if (string == null) {
                    return CollectionsKt.emptyList();
                }
                String cmd = string;
                char[] cArray = new char[]{'`'};
                String string2 = StringsKt.trimStart((String)cmd, (char[])cArray);
                cArray = new char[]{'\''};
                args2 = CollectionsKt.toMutableList((Collection)this.splitArguments(StringsKt.trimEnd((String)string2, (char[])cArray)));
                object2 = lines;
                it = object2.iterator();
                while (it.hasNext()) {
                    Object e = it.next();
                    String it2 = (String)e;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)it2)).toString(), (String)"@set INCLUDE=", (boolean)false, (int)2, null)) continue;
                    v3 = e;
                    break block6;
                }
                v3 = null;
            }
            String string = v3;
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String builtinIncludesCmd = string;
            String string3 = ((Object)StringsKt.trimStart((CharSequence)builtinIncludesCmd)).toString().substring(13);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            Iterator iterator = (Iterator)new char[1];
            iterator[0] = 59;
            List builtinIncludes = StringsKt.split$default((CharSequence)string3, (char[])iterator, (boolean)false, (int)0, (int)6, null);
            for (String builtinInclude : builtinIncludes) {
                int includeIndex = args2.indexOf(builtinInclude);
                if (includeIndex <= 0) continue;
                args2.set(includeIndex - 1, "-external:I");
            }
            return args2;
        }

        @JvmStatic
        private final List<String> splitArguments(String line) {
            ArrayList<String> result = new ArrayList<String>();
            List raw = ParametersListUtil.parse((String)line);
            StringBuilder parsingArgument = new StringBuilder();
            for (String eachArg : raw) {
                if (StringsKt.startsWith$default((String)eachArg, (String)"-", (boolean)false, (int)2, null)) {
                    if (((CharSequence)parsingArgument).length() > 0) {
                        result.add(parsingArgument.toString());
                        parsingArgument.setLength(0);
                    }
                    if (StringsKt.startsWith$default((String)eachArg, (String)"-Yc", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Yu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eachArg, (String)"-Fp", (boolean)false, (int)2, null)) {
                        String string = eachArg.substring(0, 3);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        result.add(string);
                        if (eachArg.length() <= 3) continue;
                        String string2 = eachArg.substring(3);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                        parsingArgument.append(string2);
                        continue;
                    }
                    result.add(eachArg);
                    continue;
                }
                if (((CharSequence)parsingArgument).length() > 0) {
                    parsingArgument.append(" ");
                }
                parsingArgument.append(eachArg);
            }
            if (((CharSequence)parsingArgument).length() > 0) {
                result.add(parsingArgument.toString());
            }
            return result;
        }

        @JvmStatic
        @Nullable
        public final OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
            Object v0;
            block1: {
                Iterable iterable = switches;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!(StringsKt.startsWith((String)it, (String)"/Tc", (boolean)true) || StringsKt.startsWith((String)it, (String)"/Tp", (boolean)true))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            String string = v0;
            return string == null ? null : (StringsKt.startsWith((String)string, (String)"/Tc", (boolean)true) ? (OCLanguageKind)CLanguageKind.C : (OCLanguageKind)CLanguageKind.CPP);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/MSVCCompiler$HeaderSearchPathsAndDefines;", "", "headersSearchPaths", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "defines", "", "(Ljava/util/List;Ljava/util/List;)V", "getDefines", "()Ljava/util/List;", "getHeadersSearchPaths", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.projectModel"})
    public static final class HeaderSearchPathsAndDefines {
        @NotNull
        private final List<HeadersSearchPath> headersSearchPaths;
        @NotNull
        private final List<String> defines;

        public HeaderSearchPathsAndDefines(@NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            this.headersSearchPaths = headersSearchPaths;
            this.defines = defines;
        }

        @NotNull
        public final List<HeadersSearchPath> getHeadersSearchPaths() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> getDefines() {
            return this.defines;
        }

        @NotNull
        public final List<HeadersSearchPath> component1() {
            return this.headersSearchPaths;
        }

        @NotNull
        public final List<String> component2() {
            return this.defines;
        }

        @NotNull
        public final HeaderSearchPathsAndDefines copy(@NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull List<String> defines) {
            return new HeaderSearchPathsAndDefines(headersSearchPaths, defines);
        }

        public static /* synthetic */ HeaderSearchPathsAndDefines copy$default(HeaderSearchPathsAndDefines headerSearchPathsAndDefines, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = headerSearchPathsAndDefines.headersSearchPaths;
            }
            if ((n & 2) != 0) {
                list2 = headerSearchPathsAndDefines.defines;
            }
            return headerSearchPathsAndDefines.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "HeaderSearchPathsAndDefines(headersSearchPaths=" + this.headersSearchPaths + ", defines=" + this.defines + ")";
        }

        public int hashCode() {
            int result = ((Object)this.headersSearchPaths).hashCode();
            result = result * 31 + ((Object)this.defines).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeaderSearchPathsAndDefines)) {
                return false;
            }
            HeaderSearchPathsAndDefines headerSearchPathsAndDefines = (HeaderSearchPathsAndDefines)other;
            if (!Intrinsics.areEqual(this.headersSearchPaths, headerSearchPathsAndDefines.headersSearchPaths)) {
                return false;
            }
            return Intrinsics.areEqual(this.defines, headerSearchPathsAndDefines.defines);
        }
    }
}

