/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.compilers", 1);
    private static final EventId1<DetectedCompilerKind> CIDR_COMPILER = GROUP.registerEvent("cidr.compiler", (EventField)EventFields.Enum((String)"value", DetectedCompilerKind.class));
    public static final Pattern NATIVE_GCC_REGEX = Pattern.compile("^(gcc|g\\+\\+)(-.*)?");
    private static final Map<String, DetectedCompilerKind> NAMED_COMPILER_CUSTOM_KINDS = new ContainerUtil.ImmutableMapBuilder().put((Object)"armcc", (Object)DetectedCompilerKind.KEIL_ARMCC).put((Object)"armclang", (Object)DetectedCompilerKind.KEIL_ARMCLANG).put((Object)"c++", (Object)DetectedCompilerKind.SYSTEM_DEFAULT).put((Object)"cc", (Object)DetectedCompilerKind.SYSTEM_DEFAULT).put((Object)"cl", (Object)DetectedCompilerKind.MSVC_NATIVE).put((Object)"icl", (Object)DetectedCompilerKind.MSVC_NATIVE).put((Object)"clang", (Object)DetectedCompilerKind.CLANG).put((Object)"clang++", (Object)DetectedCompilerKind.CLANG).put((Object)"dpcpp", (Object)DetectedCompilerKind.CLANG).put((Object)"icx", (Object)DetectedCompilerKind.CLANG).put((Object)"icpx", (Object)DetectedCompilerKind.CLANG).put((Object)"clang-cl", (Object)DetectedCompilerKind.CLANG_CL).put((Object)"dpcpp-cl", (Object)DetectedCompilerKind.CLANG_CL).put((Object)"cpp", (Object)DetectedCompilerKind.SYSTEM_DEFAULT).put((Object)"emcc", (Object)DetectedCompilerKind.EMSCRIPTEN).put((Object)"em++", (Object)DetectedCompilerKind.EMSCRIPTEN).put((Object)"gcc", (Object)DetectedCompilerKind.GCC_NATIVE).put((Object)"g++", (Object)DetectedCompilerKind.GCC_NATIVE).put((Object)"icc", (Object)DetectedCompilerKind.GCC_NATIVE).put((Object)"icpc", (Object)DetectedCompilerKind.GCC_NATIVE).put((Object)"icc430", (Object)DetectedCompilerKind.IAR_MSP430).put((Object)"icc8051", (Object)DetectedCompilerKind.IAR_8051).put((Object)"iccarm", (Object)DetectedCompilerKind.IAR_ARM).put((Object)"iccavr_tiny", (Object)DetectedCompilerKind.IAR_AVR).put((Object)"iccavr", (Object)DetectedCompilerKind.IAR_AVR).put((Object)"iccriscv", (Object)DetectedCompilerKind.IAR_RISCV).put((Object)"iccrx", (Object)DetectedCompilerKind.IAR_RX).put((Object)"iccstm8", (Object)DetectedCompilerKind.IAR_STM8).put((Object)"sdcc", (Object)DetectedCompilerKind.SDCC).put((Object)"xgcc", (Object)DetectedCompilerKind.GCC_NATIVE).put((Object)"xg++", (Object)DetectedCompilerKind.GCC_NATIVE).put((Object)"nvcc", (Object)DetectedCompilerKind.NVCC).build();
    private static final List<Pair<String, DetectedCompilerKind>> GCC_NAME_PARTS = Arrays.asList(Pair.pair((Object)"arm", (Object)((Object)DetectedCompilerKind.GCC_ARM)), Pair.pair((Object)"avr", (Object)((Object)DetectedCompilerKind.GCC_AVR)), Pair.pair((Object)"esp32", (Object)((Object)DetectedCompilerKind.GCC_ESP32)), Pair.pair((Object)"lx106", (Object)((Object)DetectedCompilerKind.GCC_ESP8266)), Pair.pair((Object)"mips", (Object)((Object)DetectedCompilerKind.GCC_MIPS)), Pair.pair((Object)"riscv", (Object)((Object)DetectedCompilerKind.GCC_RISCV)));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        return OCWorkspace.getInstance(project).getConfigurations().stream().flatMap(OCResolveConfiguration::getAllCompilerSettings).map(OCCompilerSettings::getCompilerExecutable).map(CompilerUsagesCollector::extractMetric).filter(Predicates.nonNull()).map(value -> CIDR_COMPILER.metric((Object)value)).collect(Collectors.toSet());
    }

    static DetectedCompilerKind extractMetric(@Nullable File compilerPath) {
        if (compilerPath == null) {
            return null;
        }
        String nakedCompilerName = CompilerUsagesCollector.stripFolderName(compilerPath.getName());
        DetectedCompilerKind value = NAMED_COMPILER_CUSTOM_KINDS.get(nakedCompilerName = nakedCompilerName.toLowerCase(Locale.ROOT));
        if (value != null) {
            return value;
        }
        if (nakedCompilerName.contains("-gcc") || nakedCompilerName.contains("-g++") || nakedCompilerName.contains("-cpp") || nakedCompilerName.contains("-c++") || nakedCompilerName.contains("-cc")) {
            for (Pair<String, DetectedCompilerKind> namingPair : GCC_NAME_PARTS) {
                if (!nakedCompilerName.contains((CharSequence)namingPair.first)) continue;
                return (DetectedCompilerKind)((Object)namingPair.second);
            }
        }
        if (NATIVE_GCC_REGEX.matcher(nakedCompilerName).matches()) {
            return DetectedCompilerKind.GCC_NATIVE;
        }
        return DetectedCompilerKind.UNKNOWN;
    }

    @NotNull
    private static String stripFolderName(String fullName) {
        int slashIndex = Math.max(fullName.lastIndexOf(47), fullName.lastIndexOf(92));
        if (slashIndex >= 0) {
            fullName = fullName.substring(slashIndex + 1);
        }
        return FileUtilRt.getNameWithoutExtension((String)fullName);
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    static enum DetectedCompilerKind {
        CLANG,
        CLANG_CL,
        EMSCRIPTEN,
        GCC_ARM,
        GCC_AVR,
        GCC_ESP32,
        GCC_ESP8266,
        GCC_MIPS,
        GCC_NATIVE,
        GCC_RISCV,
        IAR_8051,
        IAR_ARM,
        IAR_AVR,
        IAR_MSP430,
        IAR_RISCV,
        IAR_RX,
        IAR_STM8,
        KEIL_ARMCC,
        KEIL_ARMCLANG,
        MSVC_NATIVE,
        NVCC,
        SDCC,
        SYSTEM_DEFAULT,
        UNKNOWN,
        USER_DEFINED;

    }
}

