/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInterner;
import com.jetbrains.cidr.lang.workspace.compiler.CachedTempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoEventCollector;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSplitArgs;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPathTree;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CompilerInfoCache {
    @NotNull
    private static final Logger LOG = Logger.getInstance(CompilerInfoCache.class);
    private static final ExecutorService ourExecutor = CompilerInfoCache.createExecutor(CompilerInfoCache.defaultMaxProcesses(Runtime.getRuntime().availableProcessors()));
    @NotNull
    protected final Map<CompilerSettingsKey, Result> myCache = this.createCacheMap();
    @NotNull
    private final Map<CompilerSettingsKey, CompletableFuture<Result>> myInProcess = new HashMap<CompilerSettingsKey, CompletableFuture<Result>>();
    @NotNull
    protected final Object myLock = new Object();

    static int defaultMaxProcesses(int availableProcessors) {
        return Math.max(1, (int)Math.floor((double)availableProcessors * 0.8));
    }

    @NotNull
    static ExecutorService createExecutor(int maxProcesses) {
        return AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CompilerInfoCache Pool", (int)maxProcesses);
    }

    public static <ID extends Comparable<ID>> void flushConsoleMessages(@NotNull @NonNls String prefix, @NotNull Message.Type flushMessagesType, @NotNull MultiMap<ID, Message> messages, @NotNull BiConsumer<ID, String> messagesCollector) {
        for (Map.Entry entry : ContainerUtil.sorted((Collection)messages.entrySet(), Map.Entry.comparingByKey())) {
            List filtered = ContainerUtil.mapNotNull((Collection)((Collection)entry.getValue()), it -> it.getType() == flushMessagesType ? it.getText() : null);
            if (filtered.isEmpty()) continue;
            LinkedHashSet unique = new LinkedHashSet(filtered);
            String text = "\n" + prefix + ":\n\t" + StringUtil.replace((String)String.join((CharSequence)"\n", unique), (String)"\n", (String)"\n\t");
            messagesCollector.accept((Comparable)entry.getKey(), text);
        }
    }

    @NotNull
    protected Map<CompilerSettingsKey, Result> createCacheMap() {
        return new ConcurrentHashMap<CompilerSettingsKey, Result>();
    }

    @NotNull
    @TestOnly
    public Result getCompilerInfo(@NotNull Project project, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull OCWorkspaceInterner interner) {
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory), oldKey -> new CompilerSettingsKey(interner.intern(oldKey.getValue())));
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(project, compilerKind, compilerExecutable, compilerWorkingDirectory, environment, TempFilesPool.INSTANCE);
        return this.getCompilerInfo(interner, project, compiler, lang, key, switches, ourExecutor, environment, "");
    }

    @NotNull
    public CompletableFuture<Result> getCompilerInfoAsync(@NotNull Project project, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull Executor executor, @NotNull TempFilesPool tempFilesPool, @NotNull OCWorkspaceInterner interner, @NotNull String projectPath) {
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory));
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(project, compilerKind, compilerExecutable, compilerWorkingDirectory, environment, tempFilesPool);
        return this.getCompilerInfoAsync(interner, project, compiler, lang, key, switches, executor, environment, projectPath);
    }

    @NotNull
    public static CompilerSettingsKey createCompilerKey(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory) {
        StringBuilder builder = new StringBuilder().append(compilerExecutable.getPath()).append("\u0000").append(compilerWorkingDirectory).append("\u0000").append(lang.getDisplayName()).append("\u0000");
        StringUtil.join(switches.getList(CidrCompilerSwitches.Format.RAW), (String)"\u0000", (StringBuilder)builder);
        return new CompilerSettingsKey(builder.toString());
    }

    @NotNull
    Result getCompilerInfo(@NotNull OCWorkspaceInterner interner, @NotNull Project project, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env, @NotNull String projectPath) {
        CompletableFuture<Result> future = this.getCompilerInfoAsync(interner, project, compiler, lang, key, switches, executor, env, projectPath);
        while (true) {
            ProgressManager.checkCanceled();
            try {
                return future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    @NotNull
    CompletableFuture<Result> getCompilerInfoAsync(@NotNull OCWorkspaceInterner interner, @NotNull Project project, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey originalKey, @NotNull CidrCompilerSwitches originalSwitches, @NotNull Executor executor, @NotNull CidrToolEnvironment env, @NotNull String projectPath) {
        if (!this.preparseCompilerISwitch(compiler)) {
            return this.getCompilerInfoAsyncInternal(interner, compiler, lang, originalKey, originalSwitches, executor, env);
        }
        HostMachine host = env.getHostMachine();
        boolean isWindows = host.getOSType() == OSType.WIN;
        CompilerSplitArgs splitArgs = CompilerSplitArgs.parse(originalSwitches, this.preparseCompilerDefineSwitch(compiler) ? Set.of(CompilerSplitArgs.ArgType.INCLUDE, CompilerSplitArgs.ArgType.DEFINE) : Set.of(CompilerSplitArgs.ArgType.INCLUDE), true, isWindows);
        List<String> nonBuiltinSearchPaths = splitArgs.getIncludes();
        CidrCompilerSwitches switches = splitArgs.getFilteredSwitches();
        if (splitArgs.hasPrecompiledOrImplicitHeaders() || nonBuiltinSearchPaths.isEmpty()) {
            return this.getCompilerInfoAsyncInternal(interner, compiler, lang, originalKey, originalSwitches, executor, env);
        }
        File executable = ((OCCompilerBase)compiler).myExecutable;
        File workingDirectory = ((OCCompilerBase)compiler).myWorkingDirectory;
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, executable, workingDirectory));
        CompletableFuture<Result> result = this.getCompilerInfoAsyncInternal(interner, compiler, lang, key, switches, executor, env);
        CompletionStage future = result.thenApply(res -> {
            CompilerInfo info = res.getInfo();
            if (info != null) {
                ArrayList<CallSite> paths = new ArrayList<CallSite>(nonBuiltinSearchPaths);
                for (int i = 0; i < paths.size(); ++i) {
                    String path = (String)paths.get(i);
                    if (env.isEnvAbsolute(path)) continue;
                    paths.set(i, (CallSite)((Object)(env.toEnvPath(workingDirectory.getPath()) + "/" + path)));
                }
                String[] canonicalPaths = ArrayUtil.toStringArray(paths);
                List<String> resolvedPaths = CompilerInfoCache.resolvePaths(env, Arrays.asList(canonicalPaths));
                HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
                pathTree.addSearchPathsCompacting(info.getHeadersSearchPaths());
                @NotNull String rootPath = FileUtil.toSystemIndependentName((String)projectPath);
                for (String path : resolvedPaths) {
                    boolean preferQuotes = FileUtil.toSystemIndependentName((String)path).startsWith(rootPath);
                    pathTree.addSearchPathCompacting(new HeadersSearchPath(interner.intern(path), false, HeadersSearchPath.Kind.SYSTEM, preferQuotes));
                }
                List<HeadersSearchPath> headersSearchPaths = pathTree.getCompactedPaths();
                CidrCompilerSwitches compilerSwitches = lang.isCuda() ? info.getSwitches() : originalSwitches;
                CompilerInfo updatedInfo = new CompilerInfo(compilerSwitches, info.getDefines(), info.getFeatures(), headersSearchPaths, info.getImplicitIncludes(), info.getPrecompiledIncludes(), info.getWarnings(), info.getCompilerExitCode());
                return Result.create(originalKey, updatedInfo);
            }
            CompilerInfoEventCollector.COLLECT_FAILED.log(project);
            return Result.error(originalKey, Objects.requireNonNull(res.getError()));
        });
        return future;
    }

    protected boolean preparseCompilerISwitch(@NotNull OCCompiler compiler) {
        return Registry.is((String)"cidr.compiler.info.parse.switches", (boolean)true) && compiler instanceof OCCompilerBase;
    }

    protected boolean preparseCompilerDefineSwitch(@NotNull OCCompiler compiler) {
        return Registry.is((String)"cidr.compiler.info.parse.define.switch", (boolean)false) && compiler instanceof OCCompilerBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompletableFuture<Result> getCompilerInfoAsyncInternal(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env) {
        Result cached = this.myCache.get(key);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        Object object = this.myLock;
        synchronized (object) {
            cached = this.myCache.get(key);
            if (cached != null) {
                return CompletableFuture.completedFuture(cached);
            }
            CompletableFuture<Result> processing = this.myInProcess.get(key);
            if (processing == null) {
                processing = CompletableFuture.supplyAsync(() -> {
                    try {
                        ProgressManager.checkCanceled();
                        Result result = CompilerInfoCache.doCollectCompilerInfo(interner, compiler, lang, key, switches, env);
                        Object object = this.myLock;
                        synchronized (object) {
                            this.myCache.put(key, result);
                            this.myInProcess.remove(key);
                            this.cacheDidChange();
                        }
                        return result;
                    }
                    catch (ProcessCanceledException e) {
                        Object object = this.myLock;
                        synchronized (object) {
                            this.myInProcess.remove(key);
                        }
                        throw e;
                    }
                }, executor);
                this.myInProcess.put(key, processing);
            }
            return processing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUncleanResults() {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList keysToRemove = new ArrayList();
            this.myCache.forEach((key, result) -> {
                CompilerInfo info = result.getInfo();
                if (info != null && info.getCompilerExitCode() != 0) {
                    keysToRemove.add(key);
                }
            });
            for (CompilerSettingsKey key2 : keysToRemove) {
                this.myCache.remove(key2);
            }
        }
    }

    @NotNull
    private static Result doCollectCompilerInfo(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment env) {
        Result result;
        CidrEventSpan ignored = new CidrEventSpan("compilerInfo", () -> "collectCompilerInfo", () -> StringUtil.firstLast((String)switches.toString(), (int)1000));
        try {
            CompilerInfo info = compiler.collectInfo(lang, switches);
            HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
            pathTree.addSearchPathsCompacting(info.getHeadersSearchPaths());
            List<HeadersSearchPath> compactedInternedPaths = CompilerInfoCache.resolve(env, pathTree.getCompactedPaths(), interner);
            result = Result.create(key, new CompilerInfo(interner.intern(info.getSwitches(), oldSwitches -> new CidrCompilerSwitches(interner.intern(oldSwitches.getList(CidrCompilerSwitches.Format.RAW), switchesList -> ContainerUtil.map((Collection)switchesList, switchValue -> interner.intern(switchValue))))), interner.intern(info.getDefines(), oldDefines -> ContainerUtil.map((Collection)oldDefines, define -> interner.intern(define))), interner.intern(info.getFeatures()), compactedInternedPaths, info.getImplicitIncludes(), info.getPrecompiledIncludes(), info.getWarnings(), info.getCompilerExitCode()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (com.intellij.execution.ExecutionException e) {
                CompilerInfoEventCollector.COLLECT_FAILED.log();
                return Result.error(key, e);
            }
        }
        ignored.close();
        return result;
    }

    @NotNull
    private static List<HeadersSearchPath> resolve(@NotNull CidrToolEnvironment env, @NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull OCWorkspaceInterner interner) {
        HostMachine host = env.getHostMachine();
        List paths = ContainerUtil.map(headersSearchPaths, p -> p.getPath());
        List resolved = host.resolveAndCache(paths);
        int size = headersSearchPaths.size();
        assert (size == resolved.size());
        ArrayList<HeadersSearchPath> result = new ArrayList<HeadersSearchPath>(size);
        for (int i = 0; i < size; ++i) {
            result.add(new HeadersSearchPath(interner.intern((String)resolved.get(i)), headersSearchPaths.get(i).getFlags()));
        }
        return result;
    }

    @NotNull
    private static List<String> resolvePaths(@NotNull CidrToolEnvironment env, @NotNull List<String> paths) {
        HostMachine host = env.getHostMachine();
        List resolved = host.resolveAndCache(paths);
        assert (paths.size() == resolved.size());
        return ContainerUtil.map((Collection)resolved, p -> env.toLocalPath(p));
    }

    protected void cacheDidChange() {
    }

    public <ID> Session<ID> createSession(@NotNull ProgressIndicator indicator) {
        return this.createSession(indicator, null);
    }

    public <ID> Session<ID> createSession(@NotNull ProgressIndicator indicator, @Nullable OCWorkspaceInterner interner) {
        return new Session(this, indicator, interner);
    }

    public static class Message {
        @NotNull
        public final Type type;
        @NotNull
        @NlsSafe
        public final String text;

        public Message(@NotNull Type type, @NotNull String text) {
            this.type = type;
            this.text = text;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        public static enum Type {
            ERROR,
            WARNING;

        }
    }

    public static final class Result {
        @NotNull
        private final CompilerSettingsKey myKey;
        @Nullable
        private final CompilerInfo myInfo;
        @Nullable
        private final Throwable myError;

        @Contract(value="_,null,null -> fail; _,!null,!null -> fail")
        private Result(@NotNull CompilerSettingsKey key, @Nullable CompilerInfo info, @Nullable Throwable error) {
            assert (info != null ^ error != null);
            this.myKey = key;
            this.myInfo = info;
            this.myError = error;
        }

        @NotNull
        @Contract(pure=true)
        public CompilerSettingsKey getKey() {
            return this.myKey;
        }

        @Nullable
        @Contract(pure=true)
        public CompilerInfo getInfo() {
            return this.myInfo;
        }

        @Nullable
        @Contract(pure=true)
        public Throwable getError() {
            return this.myError;
        }

        public static Result create(@NotNull CompilerSettingsKey key, @NotNull CompilerInfo info) {
            return new Result(key, info, null);
        }

        public static Result error(@NotNull CompilerSettingsKey key, @NotNull Throwable error) {
            return new Result(key, null, error);
        }
    }

    public static final class Session<ID> {
        @NotNull
        private final CompilerInfoCache myCache;
        @NotNull
        private final ProgressIndicator myCallerProgressIndicator;
        @NotNull
        private final ProgressIndicator myJobsProgressIndicator;
        @NotNull
        private final CancelableExecutor myCancelableJobsExecutor;
        @NotNull
        private final TempFilesPool myTempFilesPool = new CachedTempFilesPool();
        @NotNull
        private final OCWorkspaceInterner myInterner;
        @NotNull
        private final List<Pair<Future<List<Message>>, ID>> myJobs = new ArrayList<Pair<Future<List<Message>>, ID>>();
        @NotNull
        private final AtomicLong myTimeBefore = new AtomicLong(0L);
        @NotNull
        private final AtomicInteger myCompletedJobs = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger myExpectedJobsCount = new AtomicInteger(0);

        private Session(@NotNull CompilerInfoCache cache, @NotNull ProgressIndicator indicator, @Nullable OCWorkspaceInterner interner) {
            this.myCache = cache;
            this.myInterner = interner != null ? interner : new OCWorkspaceInterner();
            this.myCallerProgressIndicator = indicator;
            this.myCallerProgressIndicator.setIndeterminate(false);
            this.myJobsProgressIndicator = new SensitiveProgressWrapper(indicator);
            this.myCancelableJobsExecutor = new CancelableExecutor(this.myJobsProgressIndicator);
        }

        public void schedule(@NotNull ID id, @NotNull OCResolveConfiguration.ModifiableModel model, @NotNull CidrToolEnvironment environment, @NotNull String projectPath) {
            if (this.myTimeBefore.get() == 0L) {
                this.myTimeBefore.set(System.currentTimeMillis());
            }
            CompletableFuture<List<Message>> future = OCWorkspaceImplUtilKt.collectCompilerSettingsAsync(model, environment, projectPath, this.myCache, this.myCancelableJobsExecutor, this.myTempFilesPool, this.myInterner, () -> {
                int completedJobs = this.myCompletedJobs.incrementAndGet();
                int expectedJobsCount = this.myExpectedJobsCount.get();
                if (expectedJobsCount == 0) {
                    expectedJobsCount = this.myJobs.size();
                }
                if (!this.myCallerProgressIndicator.isIndeterminate() && expectedJobsCount > 0) {
                    this.myCallerProgressIndicator.setFraction((double)completedJobs / (double)expectedJobsCount);
                }
            });
            this.myJobs.add(Pair.create(future, id));
        }

        public void waitForAll(@NotNull MultiMap<ID, Message> result) {
            Throwable toReport = null;
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    result.putValues(eachJob.second, (Collection)((Future)eachJob.first).get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ProcessCanceledException) {
                        this.myCallerProgressIndicator.cancel();
                        continue;
                    }
                    if (toReport == null) {
                        toReport = new RuntimeException(e);
                        continue;
                    }
                    toReport.addSuppressed(e);
                }
            }
            this.cleanTempFilesPool();
            if (toReport != null) {
                throw toReport;
            }
            this.myCallerProgressIndicator.checkCanceled();
            this.myCallerProgressIndicator.setFraction(1.0);
            long timeAfter = System.currentTimeMillis();
            OCWorkspaceImplUtilKt.getLOG().debug("Compiler info setup took " + StringUtil.formatDuration((long)(timeAfter - this.myTimeBefore.get())));
        }

        public void dispose() {
            this.myJobsProgressIndicator.cancel();
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    ((Future)eachJob.first).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException executionException) {
                }
            }
            this.cleanTempFilesPool();
        }

        public void setExpectedJobsCount(int expectedJobsCount) {
            this.myExpectedJobsCount.set(expectedJobsCount);
        }

        private void cleanTempFilesPool() {
            this.myTempFilesPool.clean();
        }

        private static final class CancelableExecutor
        implements Executor {
            @NotNull
            ProgressIndicator myIndicator;

            private CancelableExecutor(@NotNull ProgressIndicator indicator) {
                this.myIndicator = indicator;
            }

            @Override
            public void execute(@NotNull Runnable command) {
                ourExecutor.execute(() -> {
                    SensitiveProgressWrapper jobIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    ProgressManager.getInstance().runProcess(command, (ProgressIndicator)jobIndicator);
                    if (jobIndicator.isCanceled()) {
                        this.myIndicator.cancel();
                    }
                });
            }
        }
    }
}

