/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerCommandLineShortener;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClangClCompiler
extends GCCCompiler {
    public ClangClCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        super(executable, workingDirectory, env, tempFilesPool);
    }

    @Override
    @NotNull
    protected CompilerSpecificSwitchBuilder getSwitchBuilder() {
        return new ClangClSwitchBuilder();
    }

    @Override
    @NonNls
    @NotNull
    protected String adjustArgument(@NotNull String arg) {
        String trimmed = StringUtil.trimStart((String)arg, (String)"/clang:");
        if (trimmed.startsWith("/")) {
            return "-" + trimmed.substring(1);
        }
        return trimmed;
    }

    @Override
    @NotNull
    protected OCCompilerCommandLineShortener getCommandLineShortener() {
        return new MSVCResponseFileShortener();
    }

    @Override
    @NotNull
    ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        @NonNls Set skipOptions = ContainerUtil.set((Object[])new String[]{"-WX"});
        return super.runGCC(environment, this.filterOptions(options, skipOptions), fileText, warnLog);
    }
}

