/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.system.HostMachine;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public final class BaseTempFilesPool
implements TempFilesPool {
    BaseTempFilesPool() {
    }

    @Override
    @NotNull
    public Path writeToTempFile(@NotNull HostMachine host, @NotNull String fileText, @NotNull Path tmpDir, @NotNull String prefix, @NotNull String suffix) throws IOException {
        return BaseTempFilesPool.createTempFile(fileText, tmpDir, prefix, suffix);
    }

    static Path createTempFile(@NotNull String fileText, Path tmpDir, @NotNull String prefix, @NotNull String suffix) throws IOException {
        Path result = Files.createTempFile(tmpDir, prefix, suffix, new FileAttribute[0]);
        if (!fileText.isEmpty()) {
            PathKt.write((Path)result, (CharSequence)fileText, (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        return result;
    }

    @Override
    public void delete(@NotNull Path file) {
        PathKt.delete((Path)file, (boolean)false);
    }

    @Override
    public void clean() {
    }
}

