/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.ShowCompilerInfoForFile;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "appendAdditionalCompilerInfo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "context", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getContext", "getProjectAndFile", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "isHeaderOrSourceFile", "", "file", "update", "Context", "intellij.cidr.projectModel"})
public class ShowCompilerInfoForFile
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.getProjectAndFile(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Context context = this.getContext(e);
        if (context == null) {
            return;
        }
        Context context2 = context;
        Project project = context2.component1();
        VirtualFile file = context2.component2();
        OCLanguageKind kind = context2.component3();
        OCResolveConfiguration configuration = context2.component4();
        OCCompilerSettings settings = configuration.getCompilerSettings(kind, file);
        StringBuilder builder = new StringBuilder();
        builder.append("Compiler info for '" + file.getName() + "' in configuration '" + configuration.getDisplayName() + "' for language " + kind + "\n");
        builder.append("\nCompiler kind: " + settings.getCompilerKind() + " path: " + settings.getCompilerExecutable() + "\n");
        this.appendAdditionalCompilerInfo(builder, context2);
        builder.append("\nCompiler switches:\n");
        CidrCompilerSwitches switches = settings.getCompilerSwitches();
        if (switches == null) {
            builder.append("\nnull\n");
        } else {
            Iterable $this$forEach$iv = switches.getList(CidrCompilerSwitches.Format.RAW);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl = false;
                builder.append("\t").append(it).append("\n");
            }
        }
        builder.append("\nCompiler info:\n");
        builder.append("\nDefines:\n");
        for (String preprocessorDefine : settings.getPreprocessorDefines()) {
            StringBuilder stringBuilder = builder.append(preprocessorDefine);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        builder.append("\nFeatures:\n").append(CollectionsKt.joinToString$default((Iterable)settings.getCompilerFeatures().entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.2.INSTANCE, (int)30, null));
        builder.append("\n\nImplicit includes:\n" + CollectionsKt.joinToString$default((Iterable)settings.getImplicitIncludes(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.3.INSTANCE, (int)30, null));
        builder.append("\n\nHeader Search paths:\n" + CollectionsKt.joinToString$default((Iterable)settings.getHeadersSearchRoots().getAllRoots(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.4.INSTANCE, (int)30, null));
        LightVirtualFile infoFile = new LightVirtualFile("Compiler Info for '" + file.getName() + "' in '" + configuration.getDisplayName() + "'", (FileType)PlainTextFileType.INSTANCE, (CharSequence)builder);
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)infoFile, false);
    }

    protected void appendAdditionalCompilerInfo(@NotNull StringBuilder builder, @NotNull Context context) {
    }

    private final Triple<Project, VirtualFile, PsiFile> getProjectAndFile(AnActionEvent e) {
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!this.isHeaderOrSourceFile(psiFile2)) {
            return null;
        }
        return new Triple((Object)project2, (Object)file, (Object)psiFile2);
    }

    private final Context getContext(AnActionEvent e) {
        Triple<Project, VirtualFile, PsiFile> triple = this.getProjectAndFile(e);
        if (triple == null) {
            return null;
        }
        Triple<Project, VirtualFile, PsiFile> triple2 = triple;
        Project project = (Project)triple2.component1();
        VirtualFile file = (VirtualFile)triple2.component2();
        PsiFile psiFile = (PsiFile)triple2.component3();
        OCResolveConfiguration oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration(psiFile.getVirtualFile(), project);
        if (oCResolveConfiguration == null) {
            return null;
        }
        OCResolveConfiguration configuration = oCResolveConfiguration;
        OCLanguageKind oCLanguageKind = OCLanguageKindCalculatorBase.tryPsiFile(psiFile);
        if (oCLanguageKind == null) {
            return null;
        }
        OCLanguageKind kind = oCLanguageKind;
        return new Context(project, file, kind, configuration);
    }

    private final boolean isHeaderOrSourceFile(PsiFile file) {
        return OCFileTypeHelpers.isHeaderFile(file) || OCFileTypeHelpers.isSourceFile(file);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.projectModel"})
    protected static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final OCLanguageKind kind;
        @NotNull
        private final OCResolveConfiguration configuration;

        public Context(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            this.project = project;
            this.file = file;
            this.kind = kind;
            this.configuration = configuration;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind getKind() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind component3() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration component4() {
            return this.configuration;
        }

        @NotNull
        public final Context copy(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            return new Context(project, file, kind, configuration);
        }

        public static /* synthetic */ Context copy$default(Context context, Project project, VirtualFile virtualFile, OCLanguageKind oCLanguageKind, OCResolveConfiguration oCResolveConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                project = context.project;
            }
            if ((n & 2) != 0) {
                virtualFile = context.file;
            }
            if ((n & 4) != 0) {
                oCLanguageKind = context.kind;
            }
            if ((n & 8) != 0) {
                oCResolveConfiguration = context.configuration;
            }
            return context.copy(project, virtualFile, oCLanguageKind, oCResolveConfiguration);
        }

        @NotNull
        public String toString() {
            return "Context(project=" + this.project + ", file=" + this.file + ", kind=" + this.kind + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            int result = this.project.hashCode();
            result = result * 31 + this.file.hashCode();
            result = result * 31 + this.kind.hashCode();
            result = result * 31 + this.configuration.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)context.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)context.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kind, (Object)context.kind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configuration, (Object)context.configuration);
        }
    }
}

