/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class OCWorkspaceRunConfigurationListener {
    private static volatile boolean ourDisableUpdatesInTests;
    @Nullable
    private volatile OCResolveConfiguration mySelectedResolveConfiguration;

    private static void listenChanges(final @NotNull Project project) {
        final MessageBusConnection connection = project.getMessageBus().connect();
        class MyListener
        implements RunManagerListener,
        ExecutionTargetListener,
        OCWorkspaceListener {
            final AtomicInteger bulkUpdate = new AtomicInteger(0);
            final AtomicBoolean updateTarget = new AtomicBoolean();

            MyListener() {
            }

            public void beginUpdate() {
                this.bulkUpdate.incrementAndGet();
            }

            public void endUpdate() {
                if (this.bulkUpdate.decrementAndGet() == 0) {
                    this.doUpdate();
                }
            }

            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
                this.doUpdate();
            }

            @Override
            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                if (event.resolveConfigurationsChanged() || event.clientVersionChanged()) {
                    this.updateTarget.set(true);
                    this.doUpdate();
                }
            }

            void doUpdate() {
                if (ourDisableUpdatesInTests || this.bulkUpdate.get() != 0) {
                    return;
                }
                MergingUpdateQueue queue = new MergingUpdateQueue("update selected configuration", 0, true, null, (Disposable)connection, null, true);
                queue.queue(new Update("1"){

                    public void run() {
                        if (updateTarget.getAndSet(false)) {
                            ExecutionTargetManager.getInstance((Project)project).update();
                        }
                        OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(project);
                    }
                });
            }
        }
        MyListener listener = new MyListener();
        connection.subscribe(RunManagerListener.TOPIC, (Object)listener);
        connection.subscribe(ExecutionTargetManager.TOPIC, (Object)listener);
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)listener);
    }

    @RequiresEdt
    private static void updateSelectedConfiguration(@NotNull Project project) {
        OCResolveConfiguration selectedResolveConfiguration = (OCResolveConfiguration)ReadAction.compute(() -> {
            OCResolveConfiguration configuration;
            RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
            ExecutionTarget target = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
            if (settings != null && settings.getConfiguration() instanceof OCRunConfiguration && (configuration = ((OCRunConfiguration)settings.getConfiguration()).getResolveConfiguration(target)) != null) {
                return configuration;
            }
            return null;
        });
        OCWorkspaceRunConfigurationListener.setSelectedResolveConfiguration(project, selectedResolveConfiguration);
    }

    @Nullable
    public static OCResolveConfiguration getSelectedResolveConfiguration(@NotNull Project project) {
        return project.isDefault() ? null : OCWorkspaceRunConfigurationListener.getInstance((Project)project).mySelectedResolveConfiguration;
    }

    @RequiresEdt
    public static void setSelectedResolveConfiguration(@NotNull Project project, @Nullable OCResolveConfiguration selectedResolveConfiguration) {
        if (project.isDefault()) {
            return;
        }
        OCWorkspaceRunConfigurationListener configurationListener = OCWorkspaceRunConfigurationListener.getInstance(project);
        if (!Objects.equals(configurationListener.mySelectedResolveConfiguration, selectedResolveConfiguration)) {
            OCResolveConfiguration old = configurationListener.mySelectedResolveConfiguration;
            configurationListener.mySelectedResolveConfiguration = selectedResolveConfiguration;
            ApplicationManager.getApplication().runWriteAction(() -> {
                OCWorkspaceModificationTrackersImpl trackers = (OCWorkspaceModificationTrackersImpl)OCWorkspace.getInstance(project).getModificationTrackers();
                trackers.fireSelectedResolveConfigurationChanged();
            });
            OCResolveContextSettings.getInstance(project).onRunConfigurationChanged(old, selectedResolveConfiguration);
        }
    }

    @NotNull
    private static OCWorkspaceRunConfigurationListener getInstance(@NotNull Project project) {
        return (OCWorkspaceRunConfigurationListener)project.getService(OCWorkspaceRunConfigurationListener.class);
    }

    @TestOnly
    public static void setDisableUpdatesInTests(boolean value) {
        ourDisableUpdatesInTests = value;
    }

    public static class Activity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            ApplicationManager.getApplication().invokeLater(() -> {
                OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(project);
                OCWorkspaceRunConfigurationListener.listenChanges(project);
            }, project.getDisposed());
        }
    }
}

