/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCPCHCache {
    private static final NotNullLazyKey<SimpleModificationTracker, Project> PROJECT_MODIFICATION_TRACKER = NotNullLazyKey.create((String)"PROJECT_MODIFICATION_TRACKER", project -> new SimpleModificationTracker());
    private static final Key<CachedValue<PCHCache>> PCH_CACHE_KEY = Key.create((String)"PCH_CACHE_KEY");

    public static void onProjectContextChange(@NotNull Project project) {
        ((SimpleModificationTracker)PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project)).incModificationCount();
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file, @NotNull Project project) {
        return OCPCHCache.getPCHCache(project).isPCH(file);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getBuildConfigurationByPchFile(@Nullable VirtualFile pchFile, @NotNull Project project) {
        if (pchFile == null) {
            return Collections.emptyList();
        }
        return OCPCHCache.getPCHCache(project).getConfigurations(pchFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PCHCache getPCHCache(@NotNull Project project) {
        CachedValue value = (CachedValue)project.getUserData(PCH_CACHE_KEY);
        if (value == null) {
            SimpleModificationTracker modificationTracker = (SimpleModificationTracker)PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project);
            CachedValueProvider provider = () -> new CachedValueProvider.Result((Object)new PCHCache(project), new Object[]{modificationTracker});
            CachedValue newValue = CachedValuesManager.getManager((Project)project).createCachedValue(provider, false);
            value = (CachedValue)((UserDataHolderEx)project).putUserDataIfAbsent(PCH_CACHE_KEY, (Object)newValue);
        }
        if (value.hasUpToDateValue()) {
            return (PCHCache)value.getValue();
        }
        CachedValue cachedValue = value;
        synchronized (cachedValue) {
            return (PCHCache)value.getValue();
        }
    }

    private static class PCHCache {
        private final MultiMap<VirtualFile, OCResolveConfiguration> pch2configs = new MultiMap<VirtualFile, OCResolveConfiguration>(){

            @NotNull
            protected Collection<OCResolveConfiguration> createCollection() {
                return new LinkedHashSet<OCResolveConfiguration>();
            }
        };

        PCHCache(@NotNull Project project) {
            for (OCResolveConfiguration config : OCWorkspace.getInstance(project).getConfigurations()) {
                config.getAllCompilerSettings().flatMap(it -> it.getImplicitIncludes().stream()).forEach(pch -> this.pch2configs.putValue(pch, (Object)config));
            }
        }

        Collection<OCResolveConfiguration> getConfigurations(@NotNull VirtualFile pch) {
            return Collections.unmodifiableCollection(this.pch2configs.get((Object)pch));
        }

        boolean isPCH(@NotNull VirtualFile file) {
            return this.pch2configs.containsKey((Object)file);
        }
    }
}

