/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculatorBase {
    @Nullable
    public static OCLanguageKind tryPsiFile(@NotNull PsiFile file) {
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getLanguageByPsiFile(file);
            if (result == null) continue;
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind(file.getVirtualFile().getName());
    }

    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project, @NotNull String name) {
        OCLanguageKind result = OCLanguageKindCalculatorBase.tryFileExtension(project, name);
        if (result != null) {
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind(name);
    }

    @Nullable
    public static OCLanguageKind tryFileExtension(@Nullable Project project, @NotNull String name) {
        if (project == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getLanguageByExtension(project, name);
            if (result == null) continue;
            return result;
        }
        return !OCFileTypeHelpers.isHeaderFile(name) ? OCFileTypeHelpers.getLanguageKindStrict(name) : null;
    }

    @NotNull
    static List<OCLanguageKindCalculatorHelper> getHelpers() {
        return OCLanguageKindCalculatorHelper.EP_NAME.getExtensionList();
    }

    @Nullable
    static OCLanguageKind trySpecifiedFileType(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getSpecifiedLanguage(project, file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        OCLanguageKind result = OCLanguageKindCalculatorBase.trySpecifiedFileType(project, file);
        if (result != null) {
            return result;
        }
        result = OCLanguageKindCalculatorBase.tryFileExtension(project, file.getName());
        if (result != null) {
            return result;
        }
        return null;
    }
}

