/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OCNavigatableSymbolSearcher {
    public static final ExtensionPointName<OCNavigatableSymbolSearcher> EP_NAME = ExtensionPointName.create((String)"cidr.lang.navigatableSymbolSearcher");
    protected static final Logger LOG = Logger.getInstance(OCNavigatableSymbolSearcher.class);

    public static NavigatablePsiElement[] findNavigatableSymbols(@NotNull String qualifiedSignature, @NotNull Project project) {
        List searchers = EP_NAME.getExtensionList();
        if (searchers.isEmpty()) {
            LOG.warn("Cannot find any OCNavigatableSymbolSearcher: return empty result");
            return NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
        }
        Object[] combinedElements = NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
        for (OCNavigatableSymbolSearcher searcher : searchers) {
            combinedElements = (NavigatablePsiElement[])ArrayUtil.mergeArrays((Object[])combinedElements, (Object[])searcher.doFindNavigatableSymbols(qualifiedSignature, project));
        }
        return combinedElements;
    }

    protected abstract NavigatablePsiElement[] doFindNavigatableSymbols(@NotNull String var1, @NotNull Project var2);

    @NotNull
    protected String getFunctionName(@NotNull String qualifiedSignature) {
        return this.removeQuals(this.removeType(this.removeArguments(qualifiedSignature)));
    }

    @NotNull
    protected String getStrippedSignature(@NotNull String qualifiedSignature) {
        return this.removeType(this.removeTemplates(this.removeArguments(qualifiedSignature)));
    }

    @NotNull
    protected String removeType(@NotNull String qualifiedSignature) {
        String[] signatureParts = qualifiedSignature.split(" ");
        return signatureParts.length > 0 ? signatureParts[signatureParts.length - 1] : "";
    }

    protected String removeTemplates(@NotNull String signature) {
        int templateBegin = signature.indexOf(60);
        int templateEnd = signature.lastIndexOf(62);
        if (templateBegin == -1 || templateEnd == -1 || templateBegin >= templateEnd) {
            return signature;
        }
        return signature.substring(0, templateBegin) + signature.substring(templateEnd + 1);
    }

    @NotNull
    protected String removeArguments(String qualifiedSignature) {
        int parametersIndex = qualifiedSignature.lastIndexOf(40);
        if (parametersIndex == -1) {
            return qualifiedSignature;
        }
        return qualifiedSignature.substring(0, parametersIndex);
    }

    @NotNull
    protected String removeQuals(String qualifiedSignature) {
        int qualIndex = qualifiedSignature.lastIndexOf("::");
        if (qualIndex == -1) {
            return qualifiedSignature;
        }
        return qualifiedSignature.substring(qualIndex + 2);
    }
}

