/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAttributes {
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_UNUSED = "unused";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_USED = "used";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_CXX_MAYBE_UNUSED = "maybe_unused";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_CXX_NORETURN = "noreturn";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_IBOUTLET = "iboutlet";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_IBOUTLET_COLLECTION = "iboutletcollection";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_IBACTION = "ibaction";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_RETURNS_RETAINED = "ns_returns_retained";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_OVERLOADABLE = "overloadable";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_DEPRECATED = "deprecated";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_UNAVAILABLE = "unavailable";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_TRANSPARENT_UNION = "transparent_union";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_NAME = "swift_name";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_WRAPPER = "swift_wrapper";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_ASYNC_NAME = "swift_async_name";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_ASYNC = "swift_async";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_ASYNC_ERROR = "swift_async_error";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_UNUSED_MACRO = "__attribute__((unused))";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_MIN_IOS_VERSION = "__min_ios_version";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_MIN_MACOS_VERSION = "__min_macos_version";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_RETURNS_RETAINED_MACRO = "NS_RETURNS_RETAINED";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_MODE = "mode";
    public static final @NotNull Set<@NlsSafe String> CUDA_ATTRIBUTES = ContainerUtil.immutableSet((Object[])new String[]{"global", "device", "host"});

    public static boolean hasAttribute(@NotNull Collection<String> attributes, @NotNull String attribute) {
        return attributes.contains(attribute) || attributes.contains(OCAttributes.wrapWithUnderscores(attribute));
    }

    public static String makeCppAttribute(String attribute) {
        return "[[" + attribute + "]]";
    }

    @Nullable
    public static String getAttributeParameter(@NotNull Collection<String> attributes, @NotNull String attribute) {
        String plainAttributePrefix = OCAttributes.attributeParameterPrefix(attribute);
        String underscoredAttributePrefix = OCAttributes.attributeParameterPrefix(OCAttributes.wrapWithUnderscores(attribute));
        for (String curAttribute : attributes) {
            if (curAttribute.startsWith(plainAttributePrefix)) {
                return curAttribute.substring(plainAttributePrefix.length());
            }
            if (!curAttribute.startsWith(underscoredAttributePrefix)) continue;
            return curAttribute.substring(underscoredAttributePrefix.length());
        }
        return null;
    }

    @NotNull
    public static String attributeParameterPrefix(@NotNull String attribute) {
        return attribute + "#";
    }

    @NotNull
    public static String wrapWithUnderscores(@NotNull String attribute) {
        if (StringUtil.startsWithChar((CharSequence)attribute, (char)'_')) {
            return attribute;
        }
        return "__" + attribute + "__";
    }

    @NotNull
    public static String trimUnderscores(@NotNull String attribute) {
        if (attribute.length() <= 4 || !attribute.startsWith("__") || !attribute.endsWith("__")) {
            return attribute;
        }
        return attribute.substring(2, attribute.length() - 2);
    }
}

