/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FileExtensionPair
implements JDOMExternalizable {
    @NlsSafe
    @NotNull
    public final String mySourceExt;
    @NlsSafe
    @NotNull
    public final String myHeaderExt;
    @NotNull
    public final NamingConventionStyle myFileNamingConvention;

    public FileExtensionPair(@NlsSafe @NotNull String sourceExt, @NlsSafe @NotNull String headerExt, @NotNull NamingConventionStyle fileNamingConvention) {
        this.mySourceExt = sourceExt;
        this.myHeaderExt = headerExt;
        this.myFileNamingConvention = fileNamingConvention;
    }

    @NlsSafe
    public String toString() {
        return "." + this.mySourceExt + " / ." + this.myHeaderExt + " (" + this.myFileNamingConvention.toString() + ")";
    }

    public int hashCode() {
        int result = this.mySourceExt.hashCode();
        result = 31 * result + this.myHeaderExt.hashCode();
        result = 31 * result + this.myFileNamingConvention.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileExtensionPair pair = (FileExtensionPair)o;
        if (!this.mySourceExt.equals(pair.mySourceExt)) {
            return false;
        }
        if (!this.myHeaderExt.equals(pair.myHeaderExt)) {
            return false;
        }
        return this.myFileNamingConvention.equals((Object)pair.myFileNamingConvention);
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
    }

    public void writeExternal(Element parentElement) throws WriteExternalException {
        Element element = new Element("pair");
        element.setAttribute("source", this.mySourceExt);
        element.setAttribute("header", this.myHeaderExt);
        element.setAttribute("fileNamingConvention", this.myFileNamingConvention.name());
        parentElement.addContent(element);
    }

    @NotNull
    public static List<FileExtensionPair> readFileExtensionPairs(Element childElement) {
        ArrayList<FileExtensionPair> list = new ArrayList<FileExtensionPair>();
        for (Element e : childElement.getChildren("pair")) {
            String source = e.getAttributeValue("source");
            String header = e.getAttributeValue("header");
            if (source == null || header == null) continue;
            String cName = e.getAttributeValue("fileNamingConvention");
            NamingConventionStyle fileNamingConvention = NamingConventionStyle.byName(cName);
            list.add(new FileExtensionPair(source, header, fileNamingConvention));
        }
        return list;
    }
}

