/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCUsageTriggerCollector;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewHeaderFileAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewSourceFileAction
extends OCNewFileWithSelectedExtensionAction<MyCreateFileDialog> {
    public OCNewSourceFileAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message("create.cpp.source.title", new Object[0]), CidrLangBundle.message("create.cpp.source.title", new Object[0]), CidrLangIcons.FileTypes.Cpp);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        Pair<String, FileExtensionPair> nameAndExtension = this.determineNameAndExtension(selectedName, false);
        String name = (String)nameAndExtension.first;
        FileExtensionPair ext = (FileExtensionPair)nameAndExtension.second;
        String sourceName = name + "." + ext.mySourceExt;
        return new OCNewFileActionBase.NewFileNames(sourceName, this.shouldAddHeader() ? name + "." + ext.myHeaderExt : null);
    }

    private boolean shouldAddHeader() {
        return ((MyCreateFileDialog)((Object)this.getState().dialogPeer)).myShouldAddHeader;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        String headerExt = null;
        String sourceExt = null;
        String selectedExt = FileUtilRt.getExtension((String)selectedName);
        if (selectedExt.length() > 0) {
            if (OCFileTypeHelpers.isHeaderFile(selectedName)) {
                headerExt = selectedExt;
            } else if (OCFileTypeHelpers.isSourceFile(selectedName)) {
                sourceExt = selectedExt;
            }
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)selectedName);
        Couple<String> extensions = this.determineExtensions(sampleFile, sourceExt, headerExt);
        return new OCNewFileActionBase.NewFileNames(nameWithoutExtension + "." + (String)extensions.first, nameWithoutExtension + "." + (String)extensions.second);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project) {
        String headerName;
        if (this.getState() != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        if (headerName != null) {
            properties.setProperty("HEADER_FILENAME", headerName);
        }
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (StringUtil.isEmpty((String)FileUtilRt.getNameWithoutExtension((String)selectedName))) {
            return false;
        }
        String sourceName = this.getNewFileNames(selectedName).getSourceName();
        return sourceName != null && super.isValidName(sourceName) && OCFileTypeHelpers.isSourceFile(sourceName);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return OCNewHeaderFileAction.headerTemplate();
        }
        return "C Source File.c";
    }

    @Override
    @NotNull
    protected MyCreateFileDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        return new MyCreateFileDialog(defaultName, this.getHelpId());
    }

    protected class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        protected boolean myShouldAddHeader;

        public MyCreateFileDialog(@Nullable String defaultName, String helpId) {
            super(defaultName, helpId);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(CidrLangBundle.message("create.checkbox.source.associated.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateFileDialog.this.myShouldAddHeader = this.val$headerCheckBox.isSelected();
                    if (MyCreateFileDialog.this.myKindCombo != null) {
                        MyCreateFileDialog.this.reloadExtensions();
                    }
                    MyCreateFileDialog.this.validateOkAction();
                }
            });
            OCNewSourceFileAction.this.addAuxAction(createdElements -> OCUsageTriggerCollector.CREATE_SOURCE_FILE.log((Object)this.myShouldAddHeader));
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            return this.myShouldAddHeader ? super.getPresentableName(pair) : "." + pair.mySourceExt;
        }
    }
}

